self.addEventListener('message', function (e) {
    const notifications = e.data.notifications; // List of notifications
    const checkInterval = 30000; // Check every 30 seconds

    function checkNotifications() {
        const now = new Date();

        // Check for notifications that are due
        const remainingNotifications = [];
        notifications.forEach(notification => {
            const scheduledTime = new Date(notification.scheduledTime);

            if (now >= scheduledTime) {
                // Notify the main thread to send this notification
                self.postMessage({ action: 'sendNotification', notification });
            } else {
                remainingNotifications.push(notification);
            }
        });

        // Save remaining notifications back to Local Storage
        self.postMessage({ action: 'updateNotifications', notifications: remainingNotifications });
        
        // Schedule the next check
        setTimeout(checkNotifications, checkInterval);
    }

    checkNotifications();
});
