self.addEventListener('message', (event) => {
    const { transferId } = event.data;

    if (transferId) {
        processTransferAction(transferId);
    }
});

async function processTransferAction(transferId) {
    try {
        const response = await fetch(`/sales/transferaction/${transferId}`, {
            method: 'GET',
            headers: {
                'Content-Type': 'application/json'
            }
        });

        const result = await response.json();

        if (result.status === false) {
            // Retry processing if the transfer is not completed
            setTimeout(() => processTransferAction(transferId), 2000);
        } else {
            // Notify all connected clients about the completion
            const allClients = await self.clients.matchAll({ includeUncontrolled: true });
            allClients.forEach(client => {
                client.postMessage({ status: 'completed', transferId });
            });
        }
    } catch (error) {
        console.error('Error processing transfer action:', error);
        // Retry in case of an error
        setTimeout(() => processTransferAction(transferId), 5000);
    }
}
