<?php

/**
 * This is the model class for table "campaign".
 *
 * The followings are the available columns in table 'campaign':
 * @property integer $id
 * @property integer $user_id
 * @property string $date
 * @property string $time
 * @property string $title
 * @property string $details
 * @property integer $platform_id
 * @property integer $strategy_id
 * @property integer $cost
 * @property integer $paid
 * @property integer $hidden
 * @property integer $secert
 */
class Campaign extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'campaign';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id, date, time, title, strategy_id, objective_id, cost, hidden, secert', 'required'),
			array('user_id, platform_id,confirm,company_id, strategy_id, projects_id, interest_id, objective_id, cost, paid, hidden, secert, expected_leads, expected_cost_per_lead, visit_percentage, contract_percentage, av_of_unit_price,marketing_id,lockcam', 'numerical', 'integerOnly'=>true),
			array('title, building_id, notset, coldcall,fb_campaign_id', 'length', 'max'=>255),
			array('details', 'safe'),
			
			array( 'title', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'cost', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'paid', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'details', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
		

			
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id,fb_campaign_id, date, time, title, details,interest_id, platform_id, strategy_id, projects_id, objective_id, cost, paid, hidden, secert,company_id,confirm, building_id, notset, coldcall, expected_leads,marketing_id,lockcam', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		
		'employee'    => array(self::BELONGS_TO, 'User',    'user_id'),
		'platform'    => array(self::BELONGS_TO, 'Platform',    'platform_id'),
		'project'    => array(self::BELONGS_TO, 'Projects',    'projects_id'),
		'place'    => array(self::BELONGS_TO, 'Interestedplace',    'interest_id'),


		'company'    => array(self::BELONGS_TO, 'Company',    'company_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'date' => 'Date',
			'time' => 'Time',
			'title' => 'Title',
			'details' => 'Details',
			'platform_id' => 'Platform',
			'strategy_id' => 'Strategy',
			'cost' => 'Cost',
			'paid' => 'Paid',
			'hidden' => 'Hidden',
			'secert' => 'Secert',
			'projects_id' => 'projects',
			'objective_id' => 'objective',
			'interest_id' => 'Interest Place',
			'company_id' => 'Company',
			'confirm' => 'confirm',
			'fb_campaign_id' => 'Facebook Campaign ID',



		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('fb_campaign_id',$this->fb_campaign_id,true);
		$criteria->compare('details',$this->details,true);
		$criteria->compare('platform_id',$this->platform_id);
		$criteria->compare('strategy_id',$this->strategy_id);
		$criteria->compare('cost',$this->cost);
		$criteria->compare('paid',$this->paid);
		$criteria->compare('hidden',$this->hidden);
		$criteria->compare('secert',$this->secert);
		$criteria->compare('projects_id',$this->projects_id);
		$criteria->compare('projects_id',$this->projects_id);
		$criteria->compare('objective_id',$this->objective_id);
		$criteria->compare('building_id',$this->building_id);
		$criteria->compare('interest_id',$this->interest_id);
		$criteria->compare('company_id',$this->company_id);
		$criteria->compare('confirm',$this->confirm);



		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Campaign the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}




public function getAll()
	{
		return CHtml::listData(self::model()->findAll(), 'id', 'title');
	}


}
