<?php

/**
 * This is the model class for table "cil_company".
 *
 * The followings are the available columns in table 'cil_company':
 * @property integer $id
 * @property string $date
 * @property string $time
 * @property integer $renewal_days
 * @property string $name
 * @property string $number
 * @property string $email
 * @property string $body
 * @property string $header
 * @property string $footer
 * @property double $commission
 * @property string $category_ids
 */
class CilCompany extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'cil_company';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('date, time, renewal_days, name, number, email, body, commission, category_ids', 'required'),
			array('renewal_days', 'numerical', 'integerOnly'=>true),
			array('commission', 'numerical'),
			array('name, number, email, header, footer, category_ids', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, date, time, renewal_days, name, number, email, body, header, footer, commission, category_ids', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'date' => 'Date',
			'time' => 'Time',
			'renewal_days' => 'Renewal Days',
			'name' => 'Name',
			'number' => 'Number',
			'email' => 'Email',
			'body' => 'Body',
			'header' => 'Header',
			'footer' => 'Footer',
			'commission' => 'Commission',
			'category_ids' => 'Category Ids',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('renewal_days',$this->renewal_days);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('number',$this->number,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('body',$this->body,true);
		$criteria->compare('header',$this->header,true);
		$criteria->compare('footer',$this->footer,true);
		$criteria->compare('commission',$this->commission);
		$criteria->compare('category_ids',$this->category_ids,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return CilCompany the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
