<?php

// CreateColumnForm.php (protected/models/CreateColumnForm.php)

class CreateColumnForm extends CFormModel
{
    public $table_name;
    public $column_name;
    public $column_type;

    public function rules()
    {
        return array(
            array('table_name, column_name, column_type', 'required'),
            array('table_name, column_name', 'length', 'max' => 255),
            array('column_type', 'in', 'range' => array('INT(11)', 'VARCHAR(255)', 'TEXT', 'DATE')), // Adjust the range as needed
        );
    }

    public function attributeLabels()
    {
        return array(
            'table_name' => 'Table Name',
            'column_name' => 'Column Name',
            'column_type' => 'Column Type',
        );
    }
}
