<?php

/**
 * This is the model class for table "excel".
 *
 * The followings are the available columns in table 'excel':
 * @property integer $id
 * @property integer $user_id
 * @property string $name
 * @property string $no1
 * @property string $notes
 * @property string $email
 * @property string $job
 * @property string $adsetname
 * @property string $adname
 * @property string $fbid
 * @property string $status
 * @property string $no2
 * @property string $no3
 * @property string $no4
 * @property string $batch
 * @property string $area
 * @property string $campaign
 * @property string $platform
 * @property string $place
 * @property string $platformchild
 * @property string $timenote
 * @property string $excel
 * @property string $date
 * @property string $time
 * @property integer $close
 * @property integer $refused
 */
class Excel extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'excel';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('coldcall,user_id, close, refused, oldid', 'numerical', 'integerOnly'=>true),
			array('excel', 'length', 'max'=>255),
			array('row_id,err,name, no1, notes, email, job, adsetname, adname, fbid, status, substatus, no2, no3, no4, batch, area, campaign, platform, place, platformchild, timenote, date, time, sales, marketing, freshsales, duplicatedate, lastreport, actiondate, followdate, actiondetails,project,teamleader,code,duplicate,type_unit', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id,row_id, user_id, name, no1, notes, email, job, adsetname, adname, fbid, status, substatus, no2, no3, no4, batch, area, campaign, platform, place, platformchild, timenote, excel, date, time, close, refused, sales, marketing, freshsales, duplicatedate , lastreport, actiondate, followdate, actiondetails,oldid,project,teamleader,duplicate,type_unit', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'name' => 'Name',
			'no1' => 'No1',
			'notes' => 'Notes',
			'email' => 'Email',
			'job' => 'Job',
			'adsetname' => 'Adsetname',
			'adname' => 'Adname',
			'fbid' => 'Fbid',
			'status' => 'Status',
			'no2' => 'No2',
			'no3' => 'No3',
			'no4' => 'No4',
			'batch' => 'Batch',
			'area' => 'Area',
			'campaign' => 'Campaign',
			'platform' => 'Platform',
			'place' => 'Place',
			'platformchild' => 'Platformchild',
			'timenote' => 'Timenote',
			'excel' => 'Excel',
			'date' => 'Date',
			'time' => 'Time',
			'close' => 'Close',
			'refused' => 'Refused',
			'actiondate' => 'Actiondate',
			'followdate' => 'Followdate',
			'actiondetails' => 'Actiondetails',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('no1',$this->no1,true);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('job',$this->job,true);
		$criteria->compare('adsetname',$this->adsetname,true);
		$criteria->compare('adname',$this->adname,true);
		$criteria->compare('fbid',$this->fbid,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('no2',$this->no2,true);
		$criteria->compare('no3',$this->no3,true);
		$criteria->compare('no4',$this->no4,true);
		$criteria->compare('batch',$this->batch,true);
		$criteria->compare('area',$this->area,true);
		$criteria->compare('campaign',$this->campaign,true);
		$criteria->compare('platform',$this->platform,true);
		$criteria->compare('place',$this->place,true);
		$criteria->compare('platformchild',$this->platformchild,true);
		$criteria->compare('timenote',$this->timenote,true);
		$criteria->compare('excel',$this->excel,true);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('close',$this->close);
		$criteria->compare('refused',$this->refused);
		$criteria->compare('actiondate',$this->actiondate,true);
		$criteria->compare('followdate',$this->followdate,true);
		$criteria->compare('actiondetails',$this->actiondetails,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	
	
	
	
	
		public function du($duplicatex)
	{
		// @todo Please modify the following code to remove attributes that should not be searched.
        $userid=Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
      
        
        
        
        $criteria = new CDbCriteria();
        $criteria->order = 'id DESC';
        $criteria->addSearchCondition('id', $duplicatex,False, "AND");
	

		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,'defaultOrder'=>'id ASC', 
		));
	}
	
	
	
	
	
	
	
	
	
	

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Excel the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
