<?php

/**
 * This is the model class for table "lands".
 *
 * The followings are the available columns in table 'lands':
 * @property integer $id
 * @property integer $secert
 * @property integer $user_id
 * @property string $date
 * @property string $time
 * @property string $title
 * @property string $address
 * @property string $details
 * @property integer $land_area
 * @property string $type_unit
 * @property string $percentage_unit
 * @property string $price_unit
 * @property string $number_unit
 * @property integer $total_area
 * @property integer $total_price
 */
class Lands extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lands';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('secert, user_id, date, time, title, address, details, land_area, type_unit, percentage_unit, price_unit, number_unit, total_area, total_price', 'required'),
			array('secert, user_id, land_area, total_area, total_price', 'numerical', 'integerOnly'=>true),
			array('title, address, details, type_unit, percentage_unit,total_area_unit,total_price_unit, price_unit, number_unit', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, secert, user_id, date, time, title, address, details, land_area, type_unit, percentage_unit, price_unit, number_unit, total_area, total_price,total_area_unit,total_price_unit', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'secert' => 'Secert',
			'user_id' => 'User',
			'date' => 'Date',
			'time' => 'Time',
			'title' => 'Title',
			'address' => 'Address',
			'details' => 'Details',
			'land_area' => 'Land Area',
			'type_unit' => 'Type Unit',
			'percentage_unit' => 'Percentage Unit',
			'price_unit' => 'Price Unit',
			'number_unit' => 'Number Unit',
			'total_area' => 'Total Area',
			'total_price' => 'Total Price',
			'total_area_unit' => 'Total Area Unit',
			'total_price_unit' => 'Total Price Unit',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('secert',$this->secert);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('address',$this->address,true);
		$criteria->compare('details',$this->details,true);
		$criteria->compare('land_area',$this->land_area);
		$criteria->compare('type_unit',$this->type_unit,true);
		$criteria->compare('percentage_unit',$this->percentage_unit,true);
		$criteria->compare('price_unit',$this->price_unit,true);
		$criteria->compare('number_unit',$this->number_unit,true);
		$criteria->compare('total_area',$this->total_area);
		$criteria->compare('total_price',$this->total_price);
		$criteria->compare('total_area_unit',$this->total_area_unit);
		$criteria->compare('total_price_unit',$this->total_price_unit);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Lands the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
