<?php

/**
 * This is the model class for table "resale".
 *
 * The followings are the available columns in table 'resale':
 * @property integer $id
 * @property integer $user_id
 * @property string $date
 * @property string $time
 * @property integer $district
 * @property integer $plot
 * @property integer $street
 * @property integer $intersection
 * @property integer $floor
 * @property integer $flatnumber
 * @property integer $type
 * @property integer $area
 * @property integer $status
 * @property integer $rooms
 * @property integer $bathrooms
 * @property integer $images
 * @property integer $owner
 * @property integer $secuirty
 * @property string $priceusd
 * @property string $priceegp
 * @property string $details
 * @property integer $availability
 * @property integer $lastreport
 * @property string $description
 * @property integer $balcony
 * @property integer $laundryroom
 * @property integer $pool
 * @property integer $garden
 * @property integer $terrace
 * @property integer $garage
 * @property integer $advcode
 * @property string $latitude
 * @property string $longitude
 * @property string $lastcheck
 */
class Resale extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'resale';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
	    
	    
	    
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id, date, time, availability, lastcheck', 'required'),
			array('user_id, district,  street,  floor, flatnumber, type, area, buildarea, landarea, dpamount, status, rooms, bathrooms, images, owner, availability, lastreport, balcony, laundryroom, pool, garden, terrace,kitchenappliances,centralheatingcooling,servantsroom,petsallowed,electricitymeter,watermeter,naturalgas,landlinephone,securityguard,elevator,negotiable , garage,booking,developer', 'numerical', 'integerOnly'=>true),
			array('priceusd, priceegp, latitude,intersection,plot, longitude,advcode,region,deliverydate,  friend,paymentmethod, secuirty,requestby', 'length', 'max'=>255),
			array('details, description', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, date, time, district, plot, street, intersection, floor, flatnumber, type, area, status, rooms, bathrooms, images, owner, secuirty, priceusd, priceegp, details, availability, lastreport, description, balcony, laundryroom, pool, garden, terrace, garage, advcode, latitude, longitude, lastcheck, friend,booking,developer,requestby', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    
		    
		    
		'employee'    => array(self::BELONGS_TO, 'User',    'user_id'),
		'ownerr'    => array(self::BELONGS_TO, 'Owners',    'owner'),
		'districtname'    => array(self::BELONGS_TO, 'Area',    'district'),
		'regionname'    => array(self::BELONGS_TO, 'Area',    'region'),
		'floorname'    => array(self::BELONGS_TO, 'Floor',    'floor'),
		'typename'    => array(self::BELONGS_TO, 'Resaletype',    'type'),
		'developername'    => array(self::BELONGS_TO, 'Company',    'developer'),


		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'date' => 'Date',
			'time' => 'Time',
			'district' => 'District',
			'plot' => 'Plot',
			'street' => 'Street',
			'intersection' => 'Intersection',
			'floor' => 'Floor',
			'flatnumber' => 'Flatnumber',
			'type' => 'Type',
			'area' => 'Area',
			'status' => 'Status',
			'rooms' => 'Rooms',
			'bathrooms' => 'Bathrooms',
			'images' => 'Images',
			'owner' => 'Owner',
			'secuirty' => 'Secuirty',
			'priceusd' => 'Priceusd',
			'priceegp' => 'Priceegp',
			'details' => 'Details',
			'availability' => 'Availability',
			'lastreport' => 'Lastreport',
			'description' => 'Description',
			'balcony' => 'Balcony',
			'laundryroom' => 'Laundryroom',
			'pool' => 'Pool',
			'garden' => 'Garden',
			'terrace' => 'Terrace',
			'garage' => 'Garage',
			'advcode' => 'Advcode',
			'latitude' => 'Latitude',
			'longitude' => 'Longitude',
			'lastcheck' => 'Lastcheck',
						'developer' => 'Developer',

			
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.
		$criteria=new CDbCriteria;

		//$criteria->compare('owner',$id);
		
		
		
		
		 if(!empty($_REQUEST['id']) ){
            $criteria->addSearchCondition('owner', $_REQUEST['owner'],False, "AND");
            }
		
            
            if(!empty($_REQUEST['code']) ){
            $criteria->addSearchCondition('advcode', $_REQUEST['code'],False, "AND");
            }
            
            
            
               if(!empty($_REQUEST['booking']) ){
            $criteria->addSearchCondition('booking', $_REQUEST['booking'],False, "AND");
            }
            
            
            if(!empty($_REQUEST['floor_id']) ){
            $criteria->addSearchCondition('floor', $_REQUEST['floor_id'],False, "AND");
            }
            
            
            if(!empty($_REQUEST['balcony']) ){
            $criteria->addSearchCondition('balcony', $_REQUEST['balcony'],False, "AND");
            }
            
            
            
             if(!empty($_REQUEST['laundryroom']) ){
            $criteria->addSearchCondition('laundryroom', $_REQUEST['laundryroom'],False, "AND");
            }
            
            
            
            
            if(!empty($_REQUEST['pool']) ){
            $criteria->addSearchCondition('pool', $_REQUEST['pool'],False, "AND");
            }
            
            
            
            
            if(!empty($_REQUEST['garden']) ){
            $criteria->addSearchCondition('garden', $_REQUEST['garden'],False, "AND");
            }
            
            
            
            if(!empty($_REQUEST['terrace']) ){
            $criteria->addSearchCondition('terrace', $_REQUEST['terrace'],False, "AND");
            }
            
            
            
             
            
            if(!empty($_REQUEST['garage']) ){
            $criteria->addSearchCondition('garage', $_REQUEST['garage'],False, "AND");
            }
            
            
             if(!empty($_REQUEST['status']) ){
            $criteria->addSearchCondition('status', $_REQUEST['status'],False, "AND");
            }
            
            
            
            
            
        
        if(!empty($_REQUEST['buildarea']) ){
        $criteria->addSearchCondition('buildarea', $_REQUEST['buildarea'],False, "AND");
        }
        
            

if(!empty($_REQUEST['landarea']) ){
$criteria->addSearchCondition('landarea', $_REQUEST['landarea'],False, "AND");
}
            
            
       
               if(!empty($_REQUEST['region']) ){
            $criteria->addSearchCondition('region', $_REQUEST['region'],False, "AND");
            }
            
            
            
            
               if(!empty($_REQUEST['district']) ){
            $criteria->addSearchCondition('district', $_REQUEST['district'],False, "AND");
            }
            
                 
            
            
            
            
            if(!empty($_REQUEST['compound']) ){
            $criteria->addSearchCondition('compound', $_REQUEST['compound'],False, "AND");
            }

            if(!empty($_REQUEST['idx']) ){
            $criteria->addSearchCondition('id', $_REQUEST['idx'],False, "AND");
            }

            if(!empty($_REQUEST['owner']) ){
            $criteria->addSearchCondition('owner', $_REQUEST['owner'],False, "AND");
            }
            

		$criteria->compare('booking',$this->booking);
		$criteria->compare('advcode',$this->advcode, true);
		$criteria->compare('date',$this->date, true);
		$criteria->compare('time',$this->time, true);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('owner',$this->owner);
		$criteria->compare('developer',$this->developer);
		$criteria->compare('plot',$this->plot);
		$criteria->compare('district',$this->district);
		$criteria->compare('region',$this->region);
		$criteria->compare('floor',$this->floor);
		$criteria->compare('type',$this->type);
		$criteria->compare('garden',$this->garden, true);
		$criteria->compare('garage',$this->garage, true);
		$criteria->compare('pool',$this->pool, true);
		$criteria->compare('status',$this->status, true);
		$criteria->compare('intersection',$this->intersection, true);
		$criteria->compare('area',$this->area, true);
		$criteria->compare('buildarea',$this->buildarea, true);
		$criteria->compare('landarea',$this->landarea, true);
		$criteria->compare('dpamount',$this->dpamount, true);
		$criteria->compare('priceegp',$this->priceegp, true);
		$criteria->compare('priceusd',$this->priceusd, true);
		$criteria->compare('details',$this->details, true);
		$criteria->compare('description',$this->description, true);
		$criteria->compare('rooms',$this->rooms, true);
		$criteria->compare('terrace',$this->terrace, true);
		$criteria->compare('bathrooms',$this->bathrooms, true);
		$criteria->compare('balcony',$this->balcony, true);
		$criteria->compare('laundryroom',$this->laundryroom, true);
		$criteria->compare('rooms',$this->rooms, true);
		$criteria->compare('friend',$this->friend, true);
		$criteria->compare('securityguard',$this->securityguard, true);
		$criteria->compare('secuirty',$this->secuirty, true);
		$criteria->compare('electricitymeter',$this->electricitymeter, true);
		$criteria->compare('watermeter',$this->watermeter, true);
		$criteria->compare('naturalgas',$this->naturalgas, true);
		$criteria->compare('landlinephone',$this->landlinephone, true);
		$criteria->compare('elevator',$this->elevator, true);
		$criteria->compare('petsallowed',$this->petsallowed, true);
		$criteria->compare('servantsroom',$this->servantsroom, true);
		$criteria->compare('centralheatingcooling',$this->centralheatingcooling, true);
		$criteria->compare('kitchenappliances',$this->kitchenappliances, true);
		$criteria->compare('paymentmethod',$this->paymentmethod, true);
		$criteria->compare('deliverydate',$this->deliverydate, true);
		$criteria->compare('requestby',$this->requestby, true);
		
		
		$sort = new CSort();
        $criteria->order = Yii::app()->request->getParam('sort', 'id DESC');

		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,'defaultOrder'=>'id ASC', 
		));
	}
	
	
		
		public function lead($ownerx)
	{
		// @todo Please modify the following code to remove attributes that should not be searched.
        $userid=Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
      
        
        
        
        $criteria = new CDbCriteria();
        $criteria->order = 'id DESC';
       
        
        //$criteria->condition .= "file IS NOT NULL";
            $criteria->addSearchCondition('owner', $ownerx,False, "AND");

			
      

		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));
		
		
	

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,'defaultOrder'=>'id ASC', 
		));
	}

	

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Resale the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
