<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function(){
    $('select[name="in_out"]').change(function(){
        var selectedOption = $(this).val();
        $('select[name="master_account"] option').hide();
        
        if(selectedOption == "In"){
            $('select[name="master_account"] option[detype="in"]').show();
        } else if(selectedOption == "Out"){
            $('select[name="master_account"] option[detype="out"]').show();
        }
    });

    $('input[name="cashtype"]').change(function(){
        if($(this).val() == "1"){
            $('.chequedate').removeClass('d-none');
            $('.chequedate input').attr('required', 'required');
        } else {
            $('.chequedate').addClass('d-none');
            $('.chequedate input').removeAttr('required');
        }
    });

    $('select[name="master_account"]').change(function(){
        var selectedValue = $(this).val();
        $('select[name="sub_master_account"] option').hide();
        $('select[name="sub_sub_master_account"] option').hide();
        $('select[name="sub_master_account"] option[ifparent="' + selectedValue + '"]').show();
    });

    $('select[name="sub_master_account"]').change(function(){
        var selectedValue = $(this).val();
        $('select[name="sub_sub_master_account"] option').hide();
        $('select[name="sub_sub_master_account"] option[ifparent="' + selectedValue + '"]').show();
    });
});
</script>
<!--begin::Portlet-->
<div class="kt-portlet kt-portlet--height">
	<div class="kt-portlet__head">
		<div class="kt-portlet__head-label">
			<h3 class="kt-portlet__head-title">
				Daily Journal
			</h3>
		</div>
		<div class="kt-portlet__head-toolbar">
		    <a href="<?php echo Yii::app()->getBaseUrl(true) ?>/account/ocmainpage" class="btn btn-primary mr-1">Home</a>
		    <a href="<?php echo Yii::app()->getBaseUrl(true) ?>/account/ocdailyjournal" class="btn btn-info mr-1">Daily Journal</a>
		    <a href="<?php echo Yii::app()->getBaseUrl(true) ?>/account/ocdailyjournalbanks" class="btn btn-warning mr-1">Banks</a>
		    <a href="<?php echo Yii::app()->getBaseUrl(true) ?>/account/ocdailyjournalsafes" class="btn btn-success mr-1">Safe</a>
		</div>
	</div>
	<div class="kt-portlet__body">
        <div class="row">
            <div class="col-md-2">
                <label>In/Out</label>
                <select class="form-control mb-2" name="in_out">
                    <option selected disabled>Choose Input</option>
                    <option>In</option>
                    <option>Out</option>
                </select>
            </div>
            <div class="col-md-2">
                <label>Master Account</label>
                <select class="form-control mb-2" name="master_account">
                    <option selected disabled>Choose Input</option>
                    <option detype="in" value="Income">Income</option>
                    <option detype="in" value="Capital">Capital</option>
                    <option detype="out" value="Expansive">Expansive</option>
                    <option detype="out" value="Assits">Assits</option>
                </select>
            </div>
            <div class="col-md-2">
                <label>Sub Master Account</label>
                <select class="form-control mb-2" name="sub_master_account">
                    <option selected disabled>Choose Input</option>
                    <option ifparent="Income" value="Company > ADH">Company > ADH</option>
                    <option ifparent="Income" value="Company > Reportage">Company > Reportage</option>
                    <option ifparent="Income" value="Company > Mountain View">Company > Mountain View</option>
                    <option ifparent="Income" value="Company > Emaar">Company > Emaar</option>
                    <option ifparent="Income" value="Banks & Safes">Banks & Safes > Bank Alex</option>
                    <option ifparent="Income" value="Banks & Safes">Banks & Safes > Bank CIB</option>
                    <option ifparent="Income" value="Banks & Safes">Banks & Safes > Main Safe</option>
                    <option ifparent="Income" value="Banks & Safes">Banks & Safes > Secondary Safe</option>
                    <option ifparent="Capital" value="Andrew">Andrew</option>
                    <option ifparent="Capital" value="Ayman">Ayman</option>
                    <option ifparent="Capital" value="Hamdy">Hamdy</option>
                    <option ifparent="Capital" value="Ibrahim">Ibrahim</option>
                    <option ifparent="Capital" value="Waleed">Waleed</option>
                    <option ifparent="Capital" value="Atef">Atef</option>
                    <option ifparent="Capital" value="Lubna">Lubna</option>
                    <option ifparent="Capital" value="Magdy">Magdy</option>
                    <option ifparent="Expansive" value="Exp Hospitality">Exp Hospitality</option>
                    <option ifparent="Expansive" value="Exp Salary">Exp Salary</option>
                    <option ifparent="Expansive" value="Exp Marketing">Exp Marketing</option>
                    <option ifparent="Expansive" value="Exp Rent">Exp Rent</option>
                    <option ifparent="Expansive" value="Exp Electricty">Exp Electricty</option>
                    <option ifparent="Expansive" value="Exp Mobile">Exp Mobile</option>
                    <option ifparent="Expansive" value="Exp Loans">Exp Loans</option>
                    <option ifparent="Expansive" value="Exp Comissions">Exp Comissions</option>
                    <option ifparent="Assits" value="Furniture">Furniture</option>
                    <option ifparent="Assits" value="Building">Building</option>
                    <option ifparent="Assits" value="Computer">Computer</option>
                    <option ifparent="Assits" value="Insurance">Insurance</option>
                    <option ifparent="Assits" value="Electricty">Electricty</option>
                </select>
            </div>
            <div class="col-md-2">
                <label>Sub Master Account</label>
                <select class="form-control mb-2" name="sub_sub_master_account">
                    <option selected disabled>Choose Input</option>
                    <option ifparent="Exp Loans" value="1">EXP Loans > Ahmed</option>
                    <option ifparent="Exp Loans" value="2">EXP Loans > Mohamed</option>
                    <option ifparent="Exp Loans" value="3">EXP Loans > Mahmoud</option>
                    <option ifparent="Exp Loans" value="4">EXP Loans > Eslam</option>
                    <option ifparent="Exp Comissions" value="5">EXP Comissions > Ahmed</option>
                    <option ifparent="Exp Comissions" value="6">EXP Comissions > Mohamed</option>
                    <option ifparent="Exp Comissions" value="7">EXP Comissions > Mahmoud</option>
                    <option ifparent="Exp Comissions" value="8">EXP Comissions > Eslam</option>
                    <option ifparent="Exp Salary" value="9">EXP Salary > Ahmed</option>
                    <option ifparent="Exp Salary" value="10">EXP Salary > Mohamed</option>
                    <option ifparent="Exp Salary" value="11">EXP Salary > Mahmoud</option>
                    <option ifparent="Exp Salary" value="12">EXP Salary > Eslam</option>
                </select>
            </div>
            <div class="col-md-2">
                <label>Secondary Account</label>
                <select class="form-control mb-2" name="secondary_account">
                    <option selected disabled>Choose Input</option>
                    <option>Bank Alex</option>
                    <option >Bank CIB</option>
                </select>
            </div>
            <div class="col-md-2">
                <label>Amount</label>
                <input class="form-control mb-2" name="amount" type="number">
            </div>
        	<div class="col-md-2">
        		<div class="col-md-12 mb-2">
        			Cash Type
        		</div>
        		<div class="col-md-12 mb-2">
        			<label class="kt-radio kt-radio--solid kt-radio--success mr-1">
        				<input type="radio" name="cashtype" value="1" > Cheque
        				<span></span>
        			</label>
        			<label class="kt-radio kt-radio--solid kt-radio--warning">
        				<input type="radio" name="cashtype" value="3" > Bank Transfer
        				<span></span>
        			</label>
        			<label class="kt-radio kt-radio--solid kt-radio--warning">
        				<input type="radio" name="cashtype" value="4" > ATM
        				<span></span>
        			</label>
        		</div>								
        	</div>
            <div class="col-md-2 chequedate d-none">
                <label>Cheque Date</label>
                <input class="form-control mb-2 datepicker w-100" name="cheque_date" type="text">
            </div>
            <div class="col-md-12">
                <label>Description</label>
                <input class="form-control mb-2" name="description" type="text">
            </div>
        </div>
        <!-- Submit-btn -->
        <div class="row ">
        	<!-- Submit-btn -->
        	<div class="col-md-12 kt-portlet__foot pl-3 mt-4 pb-0">
        		<div class="kt-form__actions ">
        			<input type="submit" name="yt0" value="Submit" class="btn btn-success btn-md btn-tall btn-wide kt-font-bold kt-font-transform-u"/>
        			<button type="reset" class="btn btn-secondary btn-md btn-tall btn-wide">Reset</button>
        		</div>
        	</div>
        </div>
        <!-- /Submit-btn -->
    </div>
</div>
<!--begin::Portlet-->
<div class="kt-portlet kt-portlet--height-fluid">
    <div class="kt-portlet__head">
    	<div class="kt-portlet__head-label">
    		<h3 class="kt-portlet__head-title">
    			Daily Journal Result
    		</h3>
    	</div>
    </div>
    <div class="kt-portlet__body">
        <div class="row table-responsive">
            <table class="responsive dataTable w-100">
                <thead>
                    <tr>
                        <th>
                            In/Out
                        </th>
                        <th>
                            Master Account
                        </th>
                        <th>
                            Secondary Account
                        </th>
                        <th>
                            Amount
                        </th>
                        <th>
                            Description
                        </th>
                        <th>
                            Approvals
                        </th>
                        <th>
                            Print
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>
                            In
                        </td>
                        <td>
                            Bank
                        </td>
                        <td>
                            Company
                        </td>
                        <td>
                            30000
                        </td>
                        <td>
                            قيمة عمولة وحده 41
                        </td>
                        <td>
                            Approved
                        </td>
                        <td>
                            <button class="btn btn-success">Print</button>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            In
                        </td>
                        <td>
                            Bank
                        </td>
                        <td>
                            Company
                        </td>
                        <td>
                            30000
                        </td>
                        <td>
                            قيمة عمولة وحده 42
                        </td>
                        <td>
                            Approved
                        </td>
                        <td>
                            <button class="btn btn-success">Print</button>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            In
                        </td>
                        <td>
                            Bank
                        </td>
                        <td>
                            Company
                        </td>
                        <td>
                            30000
                        </td>
                        <td>
                            قيمة عمولة وحده 43
                        </td>
                        <td>
                            Approved
                        </td>
                        <td>
                            <button class="btn btn-success">Print</button>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>