<?php


	ini_set('max_execution_time', 300);
	ini_set('memory_limit', '-1');



	?>
	<div class="kt-portlet kt-portlet--height-fluid col-xl-12 col-md-12 col-lg-12" id="reportHolder">
		<div class="kt-portlet__head">
			<div class="kt-portlet__head-label">
				<h3 class="kt-portlet__head-title">
					Balance Sheet/المزانية العمومية
				</h3>
			</div>
			<div class="kt-portlet__head-toolbar">
				<div class="kt-widget__action mr-1">
					<button type="button" class="btn btn-bold btn-label-brand btn-sm"  onclick="ExportExcel1('xlsx')">Excel</button>
				</div>
				<div class="kt-widget__action">
					<button type="button" class="btn btn-bold btn-label-brand btn-sm" id="pngReportButton">PNG</button>
				</div>
			</div>
		</div>
				<div class="kt-portlet__body">
					<!--Solid Form-->
					<div class="kt-portlet__body kt-portlet__body--fit"  >
<?php
// Step 1: Fetch all nodes with their credit balances
$treeData = Yii::app()->db->createCommand("
    SELECT 
        t.id,
        t.tree_id AS parent_id,
        t.title,
        t.credit_balance_till,
        t.main_tree_id
    FROM fi_tree t
    WHERE t.main_tree_id IN (1, 2, 3)
")->queryAll();

// Step 2: Prepare arrays to hold data and balances
$nodes = [];
$parentBalances = []; // Holds the sum of children for each parent

// Initialize nodes and parent balances
foreach ($treeData as $row) {
    $id = $row['id'];
    $parentId = $row['parent_id'];
    
    // Initialize the node and parent sum array if not already initialized
    $nodes[$id] = $row;
    if (!isset($parentBalances[$id])) {
        $parentBalances[$id] = 0;
    }
    if (!isset($parentBalances[$parentId])) {
        $parentBalances[$parentId] = 0;
    }
    
    // Add this node's balance to its parent's balance
    $parentBalances[$parentId] += $row['credit_balance_till'];
}

// Step 3: Update each node's balance to include its children's sums
foreach ($parentBalances as $id => $balance) {
    if (isset($nodes[$id])) {
        $nodes[$id]['credit_balance_till'] += $balance;
    }
}

// Step 4: Initialize headers and data arrays for rendering
$headers = [];
$data = [];

// Fetch main categories and prepare headers
$mainCategories = Yii::app()->db->createCommand("
    SELECT 
        mt.code AS main_tree_id,
        mt.title AS main_title,
        COALESCE(SUM(t.credit_balance_till), 0) AS total_credit_balance_sum
    FROM fi_main_tree mt
    LEFT JOIN fi_tree t ON t.main_tree_id = mt.code
    WHERE mt.code IN (1, 2, 3)
    GROUP BY mt.code, mt.title
    ORDER BY mt.code
")->queryAll();

foreach ($mainCategories as $category) {
    $sumBracket = ' (' . number_format($category['total_credit_balance_sum'], 2) . ')';
    $headers[$category['main_tree_id']] = htmlspecialchars($category['main_title'] . $sumBracket);
}

// Step 5: Organize hierarchical data under respective main categories
foreach ($nodes as $row) {
    $mainTreeId = $row['main_tree_id'];
    $level = 1; // Default to 1 for simplicity, adjust if needed

    // Prepare display title with the updated balance
    $totalBalance = $row['credit_balance_till'];
    $displayTitle = htmlspecialchars($row['title']);
    $displayTitle .= ' (' . number_format($totalBalance, 2) . ')';
    
    // Organize data by main_tree_id and level
    $data[$mainTreeId][$level][] = str_repeat('&nbsp;&nbsp;', $level - 1) . $displayTitle;
}

// Determine the maximum number of rows needed for each main category
$maxRows = 0;
foreach ($data as $mainTreeId => $levels) {
    $rowCount = 0;
    foreach ($levels as $titles) {
        $rowCount += count($titles);
    }
    if ($rowCount > $maxRows) {
        $maxRows = $rowCount;
    }
}

// Build and display the HTML table
function build_table($headers, $data, $maxRows)
{
    $html = '<table border="1" cellpadding="5" cellspacing="0" class="table thead-light striped bordered condensed responsive dataTable">';
    
    // Build header row
    $html .= '<tr>';
    foreach ($headers as $header) {
        $html .= '<th>' . $header . '</th>';
    }
    $html .= '</tr>';
    
    // Build data rows
    for ($i = 0; $i < $maxRows; $i++) {
        $html .= '<tr>';
        foreach ($headers as $mainTreeId => $header) {
            $cellContent = '';
            $counter = 0;
            if (isset($data[$mainTreeId])) {
                foreach ($data[$mainTreeId] as $level => $titles) {
                    if (isset($titles[$i - $counter])) {
                        $cellContent = $titles[$i - $counter];
                        break;
                    }
                    $counter += count($titles);
                }
            }
            $html .= '<td>' . $cellContent . '</td>';
        }
        $html .= '</tr>';
    }
    
    $html .= '</table>';
    return $html;
}

// Output the table
if (!empty($headers)) {
    echo build_table($headers, $data, $maxRows);
}
?>












		<style>
    		span.tooltipfix {
    			width: unset;
    			display: block;
    			font-weight: 900;
    		}
			.romaAllLeadstitle{
				background: #d866e7 !Important;
				color: black !important;
			}
			.romaAllLeads{
				background: #d866e7 !Important;
				color: black !important;
			}
			.romatitle{
				background: #66d5e7 !Important;
				color: black !important;
			}
			.roma{
				background: #66d5e7 !Important;
				color: black !important;
			}
			.romaNoStatustitle{
				background: #e76666 !Important;
				color: black !important;
			}
			.romaNoStatus{
				background: #e76666 !Important;
				color: black !important;
			}

			div.fixedtableholder {
				width: calc(100% - 15em) ;
				overflow-x: scroll;
				overflow-y: visible;
				padding-bottom: 1px;
				margin-left: 15em;
			}
			.fixedtableholder .header th {
				vertical-align: middle;
				top: auto;
				min-height: 100px !important;
			}
    		.headcol {
    			position: absolute;
    			width: 189px;
    			left: 17px;
    			top: auto;
    			border-right: 0px none black;
    			border-top-width: 3px;
    			margin-top: 0px;
    			z-index: 9;
    		}
    		.headcol:before {
    			content: ' ';
    		}
    		.headcoltitle {
    			min-width: 189px !important;
    			margin: auto;
    			display: grid;
    			background: #9e9e9e !important;
    			color: white !important;
    			height: 105px !important;
    		}
		</style>
	</div>
	</div>
	</div>