<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Page</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Open Sans', sans-serif;
        }

        body {
            background-color: #f0f0f5;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            background-image: url('/bg.jpg');
            background-size: cover;
            background-position: center;
            animation: fadeInBackground 1.5s ease-in-out;
            padding: 20px; /* Add padding to prevent content from touching the edges */
        }

        /* Animation for the background */
        @keyframes fadeInBackground {
            from {
                opacity: 0;
            }
            to {
                opacity: 1;
            }
        }

        .container-login100 {
            max-width: 400px;
            width: 100%; /* Ensure the container is responsive */
            border-radius: 10px;
            overflow: hidden;
            padding: 30px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            display: flex;
            justify-content: center;
            flex-direction: column;
            background: none;
            opacity: 0;
            animation: fadeInForm 2s ease-in-out forwards;
        }

        /* Animation for the form */
        @keyframes fadeInForm {
            from {
                opacity: 0;
                transform: translateY(50px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .wrap-login100 {
            padding-bottom: 20px;
            background: none;
        }

        .login100-form-title {
            font-size: 24px;
            font-weight: 700;
            text-align: center;
            color: #333;
            padding-bottom: 50px;
        }

        .login100-form-avatar {
            display: flex;
            justify-content: center;
            padding-bottom: 30px;
        }

        .login100-form-avatar img {
            width: 150px;
            border-radius: 50%;
        }

        .wrap-input100 {
            position: relative;
            margin-bottom: 35px;
        }

        .input100 {
            width: 100%;
            padding: 10px 20px;
            font-size: 16px;
            background-color: #f0f0f5;
            border: none;
            border-radius: 5px;
            animation: fadeInInputs 1.5s ease-in-out forwards;
        }

        .focus-input100::after {
            font-size: 18px;
            color: #999;
            content: attr(data-placeholder);
            position: absolute;
            top: -15px;
            left: 0;
            padding-left: 5px;
            transition: all .4s;
        }

        .input100:focus + .focus-input100::after {
            top: -30px;
            color: #333;
        }

        .kt-login__extra {
            margin-bottom: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .kt-checkbox input {
            margin-right: 10px;
        }

        .container-login100-form-btn {
            text-align: center;
        }

        .login100-form-btn {
            width: 100%;
            padding: 10px 20px;
            background-color: #a20606;
            color: #fff;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
            transition: background-color 0.3s, transform 0.2s;
        }

        /* Animation for button hover */
        .login100-form-btn:hover {
            background-color: #555;
            transform: translateY(-3px);
        }

        /* Animation for inputs */
        @keyframes fadeInInputs {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Responsive Styles */
        @media (max-width: 768px) {
            .container-login100 {
                padding: 20px;
            }

            .login100-form-title {
                font-size: 20px;
            }

            .input100 {
                padding: 10px;
                font-size: 14px;
            }

            .login100-form-avatar img {
                width: 120px;
            }

            .login100-form-btn {
                font-size: 14px;
            }
        }

        @media (max-width: 480px) {
            .container-login100 {
                padding: 15px;
            }

            .login100-form-title {
                font-size: 18px;
            }

            .input100 {
                padding: 8px;
                font-size: 12px;
            }

            .login100-form-avatar img {
                width: 100px;
            }

            .login100-form-btn {
                font-size: 12px;
                padding: 8px;
            }
        }
        
        
        span.day-message.login100-form-title.p-b-50 {
    width: 100%;
    text-align: center;
}
    </style>
</head>
<body>

<div class="container-login100" style="
    max-width: 100% !important;
    box-shadow: none !important;
">

    <div class="wrap-login100 p-b-20">

        <?php $form=$this->beginWidget('bootstrap.widgets.TbActiveForm',array(
            'id'=>'login-form',
            'htmlOptions'=>array(
                'class'=>'login100-form validate-form',
                'data-name'=>'Email Form',
            ),
            'enableClientValidation'=>true,
            'clientOptions'=>array(
                'validateOnSubmit'=>true,
            ),
        )); ?> 

        <span class="day-message login100-form-title p-b-50">Login</span>

        <div class="wrap-input100 validate-input m-t-85 m-b-35" data-validate="Enter username">
            <input class="input100" type="text" name="LoginForm[username]" autocomplete="off">
            <span class="focus-input100" data-placeholder="Username"></span>
        </div>

        <div class="wrap-input100 validate-input m-b-30" data-validate="Enter password">
            <input class="input100" type="password" name="LoginForm[password]" autocomplete="off">
            <span class="focus-input100" data-placeholder="Password"></span>
        </div>

        <div class="row kt-login__extra m-b-20">
            <div class="col">
                <label class="kt-checkbox">
                    <input type="checkbox" name="LoginForm[rememberMe]" value="1" id="loginRememberMe" autocomplete="off"> Remember me
                    <span></span>
                </label>
            </div>
        </div>

        <div class="container-login100-form-btn">
            <button class="login100-form-btn">Login</button>
        </div>

        <?php $this->endWidget(); ?>

    </div>
</div>

</body>
</html>
