<?php 	
$userid = Yii::app()->user->id;
$user = User::model()->findByPk($userid);
?>

<?php if ($user->hr == 1) { ?>
    <?php
    $today = date("Y-m-d");    
    ?>
    <?php
    $criteria = new CDbCriteria();
    $criteria->order = 'id DESC';
    $criteria->addCondition('approved IS  NULL');
    $criteria->addBetweenCondition("date", $today, $today, 'AND');
    $allsessions = Sessions::model()->findAll($criteria);
    ?>

    <!DOCTYPE html>
    <html>
    <head>
        <title>Session List</title>
        <style>
            body {
                font-family: Arial, sans-serif;
                background-color: #f2f2f2;
                margin: 0;
                padding: 0;
            }

            .container {
                max-width: 600px;
                margin: 0 auto;
                padding: 20px;
                background-color: #fff;
                border: 1px solid #ccc;
                border-radius: 4px;
            }

            h1 {
                color: #333;
                margin-bottom: 20px;
                font-size: 24px;
                font-weight: bold;
                text-align: center;
            }

            .session {
                margin-bottom: 10px;
                padding: 10px;
                background-color: #fff;
                border: 1px solid #ccc;
                border-radius: 4px;
                box-shadow: 0 2px 2px rgba(0, 0, 0, 0.1);
                transition: box-shadow 0.3s ease-in-out;
            }

            .session:hover {
                box-shadow: 0 4px 4px rgba(0, 0, 0, 0.2);
            }

            .name {
                font-weight: bold;
                margin-bottom: 5px;
                font-size: 16px;
            }

            .code {
                color: #888;
                font-size: 14px;
            }

            .no-sessions {
                color: #888;
                text-align: center;
                margin-top: 20px;
            }
        </style>
    </head>
    <body>
        <div class="container">
            <h1>Today's Sessions: <?php echo $today; ?></h1>

            <?php if (!empty($allsessions)) { ?>
                <?php foreach ($allsessions as $sessions) {
                    $log = User::model()->findByAttributes(array('id' => $sessions->user_id));
                    ?>
                    <div class="session">
                        <div class="name"><?php echo $log->fname ?> <?php echo $log->lname ?> - <?php echo $sessions->time; ?></div>
                        <div class="code"><?php echo $sessions->code; ?></div>
                    </div>
                <?php } ?>
            <?php } else { ?>
                <p class="no-sessions">No sessions found for today.</p>
            <?php } ?>
        </div>
    </body>
    </html>
<?php } ?>
