<!DOCTYPE html>
<html>
    <head>
        <title>👋 Welcome</title>
        <link href="<?php echo Yii::app()->getBaseUrl(true) ?>/megabox/vendors/general/@fortawesome/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css" />
        
<script src="<?php echo Yii::app()->getBaseUrl(true) ?>/megabox/vendors/general/jquery/dist/jquery.js" type="text/javascript"> </script>
        
           <script>
        $(document).ready(function(){
            $('#camera-camera-form').submit(function(){
                $('input[type="submit"]').val('Loading...').prop('disabled', true).addClass('btn-dark');
            });
        });
    </script>
        <style>
            body {
                font-family: Arial, sans-serif;
                background-color: #252c51 !important;
                margin: 0;
                padding: 0;
                display: flex;
                flex-direction: column;
                align-items: center;
                justify-content: center;
                height: 100vh;
            }
            h1 {
                color: #333;
                margin-bottom: 30px;
                color:white;
                font-size:35px;
            }
            #cameraContainer {
                overflow: hidden;
                box-shadow: unset;
                margin-bottom: 20px;
                border-radius: 70px;
                float: left;
                border: 1px solid #607D8B;
                box-shadow: 1px 1px 8px #607D8B;
            }
            #videoFeed, #canvas {
                width: 100%;
                height: 100%;
            }
            #captureBtn {
                background-color: #007bff;
                color: #fff;
                padding: 10px 20px;
                border: none;
                border-radius: 4px;
                font-size: 50px;
                cursor: pointer;
                transition: background-color 0.3s ease;
                width: 3em;
                height: 3em;
                border-radius: 50%;
                margin-top: 35%;
                margin-left: auto;
                margin-right: auto;
                display: block;
            }
            #captureBtn:hover {
                background-color: #0056b3;
            }
            #location {
                font-size: 18px;
                color: #fff;
            }
            #dateTime {
                font-size: 18px;
                color: #fff;
            }
            #thumbnail {
                display: none;
                width: 200px;
                height: auto;
                margin-top: 10px;
                border: 1px solid #ccc;
                display: block;width: 200px;height: auto;margin-top: 10px;margin-bottom: 20px;border: 0px solid rgb(255 255 255);border-radius: 10px;
            }
            .awesome-list {
            	/* Create a new instance of a counter called "my-awesome-list" and set the counter to 0. */
            	counter-reset: my-awesome-list;
            	display: inline-block;
            	margin-left: 0em;
            	vertical-align: middle;
            	position: relative;
            }
            .awesome-list-item {
            	 /* Increment the "my-awesome-list" counter for every list item. */
            	counter-increment: my-awesome-list;
            	margin: 1em 0;
            	position: relative;
            	width: 100%;
            }
            .awesome-list-item::before {
            	/* Display the counter and set the list style for the list. */
            	content: counter(my-awesome-list, decimal-leading-zero); 
            	background: #8087ac;
            	border: 10px solid #2C3E50;
            	border-radius: 50%;
            	color: #FFF;
            	display: inline-block;
            	font-weight: bold;
            	font-size: 1.8em;
            	line-height: 3em;
            	position: relative;
            	text-align: center;
            	vertical-align: middle;
            	width: 3.6em;
            	height: 3.6em;
            	z-index: 2;
            }
            .awesome-list-item span{
                padding-left: 20px;
                color:white;
            }
            /* Style the submit button */
            input[type="submit"] {
                background-color: #007bff; /* Background color */
                color: #fff; /* Text color */
                border: none; /* Remove border */
                padding: 10px 20px; /* Padding for the button */
                cursor: pointer; /* Cursor style on hover */
                border-radius: 5px; /* Rounded corners */
                width: 200px;
            }
    
            /* Style the submit button on hover */
            input[type="submit"]:hover {
                background-color: #0056b3; /* Change background color on hover */
            }
        </style>
    </head>
    <body>
        <h1>👋 WELCOME</h1>
        <div class="row w-100 ml-5 mr-5" style="width:100%">
            <div class="col-12 col-md-5">
                <div id="cameraContainer">
                    <video id="videoFeed" autoplay playsinline muted></video>
                    <canvas id="canvas" style="display: none;"></canvas>
                </div>
            </div>
            <div class="col-12 col-md-3">
                <button id="captureBtn"><i class="fa-camera fa"></i></button>
            </div>
            <div class="col-12 col-md-4">
                <section class="list-intro"></section>
                <section class="awesome-list">
                    <div class="awesome-list-item"><span>Allow Location.</span></div>
                    <div class="awesome-list-item"><span>Allow Camera.</span></div>
                    <div class="awesome-list-item"><span>Capture.</span></div>
                    <div class="awesome-list-item"><span>Login.</span></div>
                </section>
            </div>
        </div>
        <p id="location"></p>
        <p id="dateTime"></p>
        <img id="thumbnail" style="display: none; width: 200px; height: auto; margin-top: 10px; border: 1px solid #ccc;" />
        <div id="result" class="form">
           
           


<?php $form=$this->beginWidget('CActiveForm', array(
'id'=>'camera-camera-form',
// Please note: When you enable ajax validation, make sure the corresponding
// controller action is handling ajax validation correctly.
// See class documentation of CActiveForm for details on this,
// you need to use the performAjaxValidation()-method described there.
'enableAjaxValidation'=>false,
)); ?>

<?php echo $form->errorSummary($model); ?>

<input name="Camera[user_id]" id="Camera_user_id" type="text"  style="display:none ;" />
<input name="latitude" id="latitude" placeholder="latitude" style="display:none ;" />
<input name="longitude" id="longitude" placeholder="longitude" style="display:none ;" />
<input name="image" id="image" placeholder="image" style="display:none ;" />

<div class="row buttons d-none">
<?php echo CHtml::submitButton('Submit'); ?>
</div>

<?php $this->endWidget(); ?>
           
        </div>
        
        
        
    <script>
// Get access to the camera
        const video = document.getElementById('videoFeed');
        navigator.mediaDevices.getUserMedia({ video: true })
            .then(function (stream) {
                video.srcObject = stream;
            })
            .catch(function (error) {
                console.error('Error accessing the camera: ', error);
            });

        // Capture a photo from the video feed
        const captureBtn = document.getElementById('captureBtn');
captureBtn.addEventListener('click', function () {
    const videoid = document.getElementById('image');
    const canvas = document.getElementById('canvas');
    const latitudeID = document.getElementById('latitude');
    const longitudeID = document.getElementById('longitude');
    
    
    const context = canvas.getContext('2d');
    canvas.width = video.videoWidth;
    canvas.height = video.videoHeight;
    context.drawImage(video, 0, 0, canvas.width, canvas.height);

    // Convert the canvas data to a base64 encoded string
    const imageDataURL = canvas.toDataURL('image/png');

    // Set the base64 encoded string as the value of the input field
    videoid.value = imageDataURL;

    // Show the thumbnail
    const thumbnailImage = document.getElementById('thumbnail');
    thumbnailImage.style.display = 'block';
    thumbnailImage.src = imageDataURL;


            // Here, you can use the canvas data for further processing, such as face detection.

            // If you want to access the user's geolocation, you can use the Geolocation API.
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(function (position) {
                    const latitude = position.coords.latitude;
                    const longitude = position.coords.longitude;
                    const locationElement = document.getElementById('location');
                    locationElement.textContent = 'Location: ' + latitude + ', ' + longitude;
latitudeID.value = latitude;
longitudeID.value = longitude;
 const buttons = document.querySelector('.buttons');
            buttons.classList.remove('d-none');
                    // Get the current date and time
                    const now = new Date();
                    const dateTimeElement = document.getElementById('dateTime');
                    dateTimeElement.textContent = 'Date and Time: ' + now.toLocaleString();
                }, function (error) {
                    console.error('Error getting geolocation: ', error);
                });
            } else {
                console.error('Geolocation is not supported by this browser.');
            }
        });
    </script>
        <?php if(strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'mobile') ){ ?>
        <style>
            .col-12 {
                width: 100% !important;
                flex: 0 0 100%;
                max-width: 100%;
                margin: auto;
                float: none;
            }
            .col-12  > div {
                width: 100% !important;
                margin-top: 20px;
                margin-bottom: 20px !important;
            }
            .col-12  > button {
                margin-top: 20px !important;
                margin-bottom: 20px !important;
            }
            body {
                margin-top:20px !important;
                height: unset !important;
            }
        </style>
        <?php }else{ ?>
    	<link href="<?php echo Yii::app()->getBaseUrl(true) ?>/megabox/css/demo6/style.bundle.css" rel="stylesheet" type="text/css" />
    	<link href="<?php echo Yii::app()->getBaseUrl(true) ?>/megabox/css/demo7/style.custom.css" rel="stylesheet" type="text/css" />
        <script src="<?php echo Yii::app()->getBaseUrl(true) ?>/megabox/vendors/general/jquery/dist/jquery.js" type="text/javascript"></script>
        <script src="<?php echo Yii::app()->getBaseUrl(true) ?>/megabox/vendors/general/popper.js/dist/umd/popper.js" type="text/javascript"></script>
        <script src="<?php echo Yii::app()->getBaseUrl(true) ?>/megabox/vendors/general/bootstrap/dist/js/bootstrap.min.js" type="text/javascript"></script>
        <?php } ?>
    </body>
</html>