<?php

function sendRequest($url, $data) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_HEADER, true);

    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        echo 'cURL Error: ' . curl_error($ch) . "\n";
        curl_close($ch);
        return null;
    }

    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
    $header = substr($response, 0, $header_size);
    $body = substr($response, $header_size);

    echo "HTTP Code: $http_code\n";
    echo "Headers:\n$header\n";
    echo "Body:\n$body\n";

    curl_close($ch);

    return array('http_code' => $http_code, 'body' => $body);
}

function generateChallenge($username) {
    $url = 'https://192.168.1.24:8089/api';
    $data = json_encode(array(
        'request' => array(
            'action' => 'challenge',
            'user' => $username,
            'version' => '1.0'
        )
    ));

    $response = sendRequest($url, $data);
    if (!$response) {
        return null;
    }

    if ($response['http_code'] !== 200) {
        echo "Error: HTTP Code " . $response['http_code'] . "\n";
        return null;
    }

    $decoded_response = json_decode($response['body'], true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        echo 'JSON decode error: ' . json_last_error_msg() . "\n";
        return null;
    }
    
    return $decoded_response['response']['challenge'] ?? null;
}

function login($username, $password, $challenge) {
    $url = 'https://192.168.1.24:8089/api';
    $token = md5($challenge . $password);
    $data = json_encode(array(
        'request' => array(
            'action' => 'login',
            'token' => $token,
            'user' => $username,
            'url' => $url
        )
    ));

    $response = sendRequest($url, $data);
    if (!$response) {
        return null;
    }

    if ($response['http_code'] !== 200) {
        echo "Error: HTTP Code " . $response['http_code'] . "\n";
        return null;
    }

    $decoded_response = json_decode($response['body'], true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        echo 'JSON decode error: ' . json_last_error_msg() . "\n";
        return null;
    }
    
    return $decoded_response['response']['cookie'] ?? null;
}

function queryCdr($cookie, $caller, $callee) {
    $url = 'https://192.168.1.24:8089/api';
    $data = json_encode(array(
        'request' => array(
            'action' => 'cdrapi',
            'cookie' => $cookie,
            'caller' => $caller,
            'callee' => $callee,
            'format' => 'json'
        )
    ));

    $response = sendRequest($url, $data);
    if (!$response) {
        return null;
    }

    if ($response['http_code'] !== 200) {
        echo "Error: HTTP Code " . $response['http_code'] . "\n";
        return null;
    }

    $decoded_response = json_decode($response['body'], true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        echo 'JSON decode error: ' . json_last_error_msg() . "\n";
        return null;
    }
    
    return $decoded_response;
}

// Define your credentials
$username = 'crmapi';
$password = 'crmapi123'; // Replace with your actual password

// Step 1: Generate the challenge
$challenge = generateChallenge($username);
if (!$challenge) {
    die('Failed to get challenge.');
}

// Step 2: Login and get the session cookie
$cookie = login($username, $password, $challenge);
if (!$cookie) {
    die('Failed to login and get cookie.');
}

// Step 3: Query CDR
$caller = '01117420049';
$callee = '1003';
$cdrResult = queryCdr($cookie, $caller, $callee);

// Output the CDR result
echo json_encode($cdrResult, JSON_PRETTY_PRINT);

?>
