<?php 
// Your view file, e.g., protected/views/your_view_file.php

// Step 1: Create the SQL query
$sql = "SELECT 
            d.id, 
            d.user_id, 
            u1.fname as user_fname, 
            u1.lname as user_lname, 
            d.date, 
            d.time, 
            d.lead_id, 
            d.tel, 
            d.title, 
            d.user_sales, 
            u2.fname as user_sales_fname, 
            u2.lname as user_sales_lname, 
            d.camp_id, 
            d.platform_id, 
            d.details 
        FROM 
            deleteleads d
        LEFT JOIN 
            user u1 ON d.user_id = u1.id
        LEFT JOIN 
            user u2 ON d.user_sales = u2.id
        ORDER BY 
            d.id DESC
        LIMIT 100";

// Step 2: Execute the query
$command = Yii::app()->db->createCommand($sql);
$results = $command->queryAll();

// Step 3: Display the results in an HTML table
?>

<table border="1" class="dataTable responsive table ">
    <tr>
        <th>ID</th>
        <th>User</th>
        <th>Date</th>
        <th>Time</th>
        <th>Lead ID</th>
        <th>Tel</th>
        <th>Title</th>
        <th>User Sales</th>
        <th>Camp ID</th>
        <th>Platform ID</th>
        <th>Details</th>
    </tr>
    <?php foreach ($results as $row): ?>
    <tr>
        <td><?php echo CHtml::encode($row['id']); ?></td>
        <td><?php echo CHtml::encode($row['user_fname'] . ' ' . $row['user_lname']); ?></td>
        <td><?php echo CHtml::encode($row['date']); ?></td>
        <td><?php echo CHtml::encode($row['time']); ?></td>
        <td><?php echo CHtml::encode($row['lead_id']); ?></td>
        <td><?php echo CHtml::encode($row['tel']); ?></td>
        <td><?php echo CHtml::encode($row['title']); ?></td>
        <td><?php echo CHtml::encode($row['user_sales_fname'] . ' ' . $row['user_sales_lname']); ?></td>
        <td><?php echo CHtml::encode($row['camp_id']); ?></td>
        <td><?php echo CHtml::encode($row['platform_id']); ?></td>
        <td><?php echo CHtml::encode($row['details']); ?></td>
    </tr>
    <?php endforeach; ?>
</table>
