<?php

class GrandstreamApi extends CApplicationComponent
{
    public $apiId;
    public $secretKey;
    public $baseUrl = 'https://api.grandstream.com';

    public function init()
    {
        if (empty($this->apiId) || empty($this->secretKey)) {
            throw new CException('API ID and Secret Key must be set.');
        }
        parent::init();
    }

    private function getHeaders()
    {
        return [
            'Authorization: Bearer ' . $this->secretKey,
            'Content-Type: application/json',
        ];
    }

    public function fetchRecordedCalls()
    {
        $url = $this->baseUrl . '/path/to/recorded/calls';
        $ch = curl_init($url);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $this->getHeaders());

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        if ($httpCode != 200) {
            throw new Exception('Error fetching recorded calls: ' . $response);
        }

        curl_close($ch);

        return json_decode($response, true);
    }
}
