<?php

/**
 * This is the model class for table "collectedtcr".
 *
 * The followings are the available columns in table 'collectedtcr':
 * @property integer $id
 * @property string $date
 * @property string $time
 * @property integer $user_id
 * @property integer $tcr_id
 * @property integer $debit_tree_id
 * @property integer $credit_tree_id
 * @property string $amount
 */
class Collectedtcr extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'collectedtcr';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('date, time, user_id, debit_tree_id, credit_tree_id, amount', 'required'),
			array('user_id, tcr_id, debit_tree_id, credit_tree_id', 'numerical', 'integerOnly'=>true),
			array('amount', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, date, time, user_id, tcr_id, debit_tree_id, credit_tree_id, amount', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'date' => 'Date',
			'time' => 'Time',
			'user_id' => 'User',
			'tcr_id' => 'Tcr',
			'debit_tree_id' => 'Debit Tree',
			'credit_tree_id' => 'Credit Tree',
			'amount' => 'Amount',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('tcr_id',$this->tcr_id);
		$criteria->compare('debit_tree_id',$this->debit_tree_id);
		$criteria->compare('credit_tree_id',$this->credit_tree_id);
		$criteria->compare('amount',$this->amount,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Collectedtcr the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
