<?php

/**
 * This is the model class for table "contracts".
 *
 * The followings are the available columns in table 'contracts':
 * @property integer $id
 * @property integer $user_id
 * @property integer $reservation_id
 * @property string $date
 * @property string $time
 * @property string $contract_details
 * @property string $file
 * @property integer $secert
 */
class Contracts extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'contracts';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
            array('file', 'file', 'types'=>'jpg, pdf, png, xlsx, csv, cad, xls','safe' => true ,'allowEmpty' => true),
			//array('user_id, reservation_id, date, time, contract_details, file, secert', 'required'),
			array('user_id, reservation_id, secert,contract_type', 'numerical', 'integerOnly'=>true),
			array('file', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, reservation_id, date, time, contract_details, file, secert', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(

'reservation'    => array(self::BELONGS_TO, 'Reservation',    'reservation_id'),
'contract'    => array(self::BELONGS_TO, 'Contract',    'contract_type'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'reservation_id' => 'Reservation',
			'date' => 'Date',
			'time' => 'Time',
			'contract_details' => 'Contract Details',
			'file' => 'File',
			'contract_type' => 'Contract Type',
			'secert' => 'Secert',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('reservation_id',$this->reservation_id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('contract_details',$this->contract_details,true);
		$criteria->compare('file',$this->file,true);
		$criteria->compare('secert',$this->secert);
		$criteria->compare('contract_type',$this->contract_type);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Contracts the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
