<?php

/**
 * This is the model class for table "duplicate".
 *
 * The followings are the available columns in table 'duplicate':
 * @property integer $id
 * @property string $title
 * @property string $tel
 * @property integer $user_id
 * @property string $date
 * @property string $time
 * @property integer $leads_id
 */
class Duplicate extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'duplicate';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('title, tel, user_id, date, time, leads_id', 'required'),
			array('user_id, leads_id,integration,international_code,campaign_id,user_sales,transfer,excel_id,acu_sales,confirm,project_id', 'numerical', 'integerOnly'=>true),
			array('title, tel,campaign_id,user_sales,confirm_details', 'length', 'max'=>255),
			array('details', 'safe'),

			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, title, tel, user_id, date, time, leads_id,integration,details,transfer,acu_sales,project_id', 'safe', 'on'=>'search'),
			
			
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
        'xlead' => array(self::BELONGS_TO, 'Leads', 'leads_id'),
        'blead' => array(self::BELONGS_TO, 'BrokerLeads', 'leads_id'),
        'employee'    => array(self::BELONGS_TO, 'User',    'user_id'),
        'campaign'    => array(self::BELONGS_TO, 'Campaign',    'campaign_id'),

		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'title' => 'Title',
			'tel' => 'Tel',
			'user_id' => 'User',
			'date' => 'Date',
			'time' => 'Time',
			'leads_id' => 'Leads',
			'integration' => 'integration',
			'international_code' => 'international code',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('tel',$this->tel,true);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('leads_id',$this->leads_id);
		$criteria->compare('integration',$this->integration);
		$criteria->compare('international_code',$this->international_code);
		$criteria->compare('campaign_id',$this->campaign_id);
		$criteria->compare('user_sales',$this->user_sales);
		$criteria->compare('acu_sales',$this->acu_sales);
		$criteria->compare('confirm_details',$this->confirm_details);



		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Duplicate the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
