<?php

/**
 * This is the model class for table "fi_generalledgergroup".
 *
 * The followings are the available columns in table 'fi_generalledgergroup':
 * @property integer $id
 * @property string $date
 * @property string $time
 * @property integer $user_id
 * @property string $details
 * @property integer $status
 * @property integer $financial_year_id
 * @property integer $financial_year_other
 * @property double $debit
 * @property double $credit
 * @property double $total
 * @property integer $done
 */
class FiGeneralledgergroup extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'fi_generalledgergroup';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('date, time, user_id', 'required'),
			array('user_id, status, financial_year_id, financial_year_other, done,screen', 'numerical', 'integerOnly'=>true),
			array('debit, credit, total', 'numerical'),
			array('details,financialcenter', 'length', 'max'=>250),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, date, time, user_id, details, status, financial_year_id, financial_year_other, debit, credit, total, done,financialcenter,screen', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'date' => 'Date',
			'time' => 'Time',
			'user_id' => 'User',
			'details' => 'Details',
			'status' => 'Status',
			'financial_year_id' => 'Financial Year',
			'financial_year_other' => 'Financial Year Other',
			'debit' => 'Debit',
			'credit' => 'Credit',
			'total' => 'Total',
			'done' => 'Done',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('details',$this->details,true);
		$criteria->compare('status',$this->status);
		$criteria->compare('financial_year_id',$this->financial_year_id);
		$criteria->compare('financial_year_other',$this->financial_year_other);
		$criteria->compare('debit',$this->debit);
		$criteria->compare('credit',$this->credit);
		$criteria->compare('total',$this->total);
		$criteria->compare('done',$this->done);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}



	public function screen()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;


if(!empty($_REQUEST['screen']) ){
			$criteria->addSearchCondition('screen', $_REQUEST['screen'],TRUE, "AND");
		}	
	

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}





	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return FiGeneralledgergroup the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
