<?php

/**
 * This is the model class for table "hr_applicant".
 *
 * The followings are the available columns in table 'hr_applicant':
 * @property integer $id
 * @property integer $user_id
 * @property string $name
 * @property string $email
 * @property integer $mobile_number
 * @property string $experience
 * @property string $education_degree
 * @property string $education_details
 * @property string $skills
 * @property string $cv
 * @property string $date
 * @property string $time
 * @property string $platform
 * @property string $response
 * @property string $user_control
 * @property integer $interviewer_id
 * @property string $reason_for_refuse
 */
class HrApplicant extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'hr_applicant';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id, name, email, mobile_number, cv, date, time', 'required'),
			array('user_id, mobile_number, interviewer_id', 'numerical', 'integerOnly'=>true),
			array('name, email, experience, education_degree, education_details, skills, cv, platform, response, user_control, reason_for_refuse', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, name, email, mobile_number, experience, education_degree, education_details, skills, cv, date, time, platform, response, user_control, interviewer_id, reason_for_refuse', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'name' => 'Name',
			'email' => 'Email',
			'mobile_number' => 'Mobile Number',
			'experience' => 'Experience',
			'education_degree' => 'Education Degree',
			'education_details' => 'Education Details',
			'skills' => 'Skills',
			'cv' => 'Cv',
			'date' => 'Date',
			'time' => 'Time',
			'platform' => 'Platform',
			'response' => 'Response',
			'user_control' => 'User Control',
			'interviewer_id' => 'Interviewer',
			'reason_for_refuse' => 'Reason For Refuse',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('mobile_number',$this->mobile_number);
		$criteria->compare('experience',$this->experience,true);
		$criteria->compare('education_degree',$this->education_degree,true);
		$criteria->compare('education_details',$this->education_details,true);
		$criteria->compare('skills',$this->skills,true);
		$criteria->compare('cv',$this->cv,true);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('platform',$this->platform,true);
		$criteria->compare('response',$this->response,true);
		$criteria->compare('user_control',$this->user_control,true);
		$criteria->compare('interviewer_id',$this->interviewer_id);
		$criteria->compare('reason_for_refuse',$this->reason_for_refuse,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrApplicant the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
