<?php

/**
 * This is the model class for table "hr_attendance".
 *
 * The followings are the available columns in table 'hr_attendance':
 * @property integer $id
 * @property integer $user_id
 * @property string $name
 * @property string $dept_name
 * @property string $date
 * @property string $day
 * @property string $attendance_time
 * @property string $attendance_latitude
 * @property string $attendance_longitude
 * @property string $leave_time
 * @property integer $working_hours
 * @property string $reg_no
 * @property integer $shift
 * @property integer $late_min
 * @property string $report_name
 * @property string $leave_latitude
 * @property string $leave_longitude
 * @property string $image
 */
class HrAttendance extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'hr_attendance';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id', 'required'),
			            array('reg_no','unique'),

			
			array('user_id', 'numerical', 'integerOnly'=>true),
			array('name, dept_name, day, attendance_latitude, attendance_longitude, reg_no, report_name, leave_latitude, leave_longitude, late_min', 'length', 'max'=>255),
			array('date, attendance_time, leave_time', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, name, dept_name, date, day, attendance_time, attendance_latitude, attendance_longitude, leave_time, working_hours, reg_no, shift, late_min, report_name, leave_latitude, leave_longitude, image,attendance_image,leave_image,rival,extratime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'name' => 'Name',
			'dept_name' => 'Dept Name',
			'date' => 'Date',
			'day' => 'Day',
			'attendance_time' => 'Attendance Time',
			'attendance_latitude' => 'Attendance Latitude',
			'attendance_longitude' => 'Attendance Longitude',
			'leave_time' => 'Leave Time',
			'working_hours' => 'Working Hours',
			'reg_no' => 'Reg No',
			'shift' => 'Shift',
			'late_min' => 'Late Min',
			'report_name' => 'Report Name',
			'leave_latitude' => 'Leave Latitude',
			'leave_longitude' => 'Leave Longitude',
			'image' => 'Image',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	 
	 
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

	$today = date("Y-m-d");                     // 03.10.01






$criteria->addBetweenCondition("date",$start,$end,'AND');

    
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	
	
	
	 
	public function user()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

	$today = date("Y-m-d");                     // 03.10.01
	        $userid=Yii::app()->user->id;

//var_dump();exit;

$start = date("Y-m-01");  
$end = date("Y-m-31");  
$criteria->addSearchCondition('date', $today, false);
$criteria->addSearchCondition('user_id', $userid, false);

    
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	
	
	
	
	public function searchattendance()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

	
	$criteria = new CDbCriteria();
		$criteria->order = 'date DESC';
		$criteria->addBetweenCondition("date",$_REQUEST['startdate2'],$_REQUEST['enddate2'],'AND');
 		$criteria->addSearchCondition('user_id', $_REQUEST['user'],false, "AND");

    
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	
	
	
	
	
	

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrAttendance the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
