<?php

/**
 * This is the model class for table "installmentsrequest".
 *
 * The followings are the available columns in table 'installmentsrequest':
 * @property integer $id
 * @property integer $lead_id
 * @property integer $user_id
 * @property integer $request_id
 * @property integer $unit_id
 * @property string $date
 * @property string $payment_date
 * @property integer $amount
 */
class Installmentsrequest extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'installmentsrequest';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('lead_id, user_id, request_id, unit_id, date, payment_date, amount', 'required'),
			array('lead_id, user_id, request_id, unit_id, amount', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, lead_id, user_id, request_id, unit_id, date, payment_date, amount', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'lead_id' => 'Lead',
			'user_id' => 'User',
			'request_id' => 'Request',
			'unit_id' => 'Unit',
			'date' => 'Date',
			'payment_date' => 'Payment Date',
			'amount' => 'Amount',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('lead_id',$this->lead_id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('request_id',$this->request_id);
		$criteria->compare('unit_id',$this->unit_id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('payment_date',$this->payment_date,true);
		$criteria->compare('amount',$this->amount);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Installmentsrequest the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
