<?php

/**
 * This is the model class for table "leadsfreshmonthreport".
 *
 * The followings are the available columns in table 'leadsfreshmonthreport':
 * @property integer $id
 * @property integer $leadsfreshmonth_id
 * @property integer $result
 * @property integer $qualified
 * @property string $startdate
 * @property string $year
 */
class Leadsfreshmonthreport extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'leadsfreshmonthreport';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
		    array('startdate','unique'),

			array('leadsfreshmonth_id', 'required'),
			array('leadsfreshmonth_id, result, qualified', 'numerical', 'integerOnly'=>true),
			array('year', 'length', 'max'=>4),
			array('startdate', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, leadsfreshmonth_id, result, qualified, startdate, year', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'leadsfreshmonth_id' => 'Leadsfreshmonth',
			'result' => 'Result',
			'qualified' => 'Qualified',
			'startdate' => 'Startdate',
			'year' => 'Year',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('leadsfreshmonth_id',$this->leadsfreshmonth_id);
		$criteria->compare('result',$this->result);
		$criteria->compare('qualified',$this->qualified);
		$criteria->compare('startdate',$this->startdate,true);
		$criteria->compare('year',$this->year,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Leadsfreshmonthreport the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
