<?php

/**
 * This is the model class for table "marketingcosts".
 *
 * The followings are the available columns in table 'marketingcosts':
 * @property integer $id
 * @property integer $user_id
 * @property integer $campaign_id
 * @property string $date
 * @property string $details
 * @property double $price
 */
class Marketingcosts extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'marketingcosts';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id, date, details, price', 'required'),
			array('user_id, campaign_id ,service_id', 'numerical', 'integerOnly'=>true),
			array('price', 'numerical'),
			
			
			array( 'details', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),

			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, campaign_id, date, details, price', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		'campaign'    => array(self::BELONGS_TO, 'Campaign',    'campaign_id'),
		'service'    => array(self::BELONGS_TO, 'ServicePayment',    'service_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'campaign_id' => 'Campaign',
			'service_id' => 'Service',
			'date' => 'Date',
			'details' => 'Details',
			'price' => 'Price',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('campaign_id',$this->campaign_id);
		$criteria->compare('service_id',$this->service_id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('details',$this->details,true);
		$criteria->compare('price',$this->price);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Marketingcosts the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
