<?php

/**
 * This is the model class for table "tcr".
 *
 * The followings are the available columns in table 'tcr':
 * @property integer $id
 * @property integer $user_id
 * @property string $date
 * @property string $time
 * @property integer $company
 * @property string $sales
 * @property string $teamleader
 * @property string $manager
 * @property string $marketing
 * @property string $develpoer
 * @property integer $request_id
 * @property string $details
 * @property string $resv_date
 * @property string $license
 * @property string $destinations
 * @property string $unit_type
 * @property string $client_name
 * @property string $mobile_number
 * @property string $current_address
 * @property integer $job_title
 * @property string $email_address
 * @property string $source_of_lead
 * @property string $total_price
 * @property string $contract
 * @property string $project
 * @property string $unit_number
 * @property string $bua
 * @property string $outdoor_area
 * @property string $transaction_type
 * @property string $frowner
 * @property integer $req_id
 * @property string $confirm
 * @property string $lastactionby
 * @property string $due_date
 * @property string $amount
 * @property string $bank
 * @property string $bankcheck
 * @property string $settlement
 * @property string $banker_id
 */
class Tcr extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tcr';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id, date, time, req_id', 'required'),
			array('user_id, company, request_id, job_title, req_id', 'numerical', 'integerOnly'=>true),
			array('sales, teamleader, manager, marketing, develpoer, resv_date, license, destinations, unit_type, client_name, mobile_number, current_address, email_address, source_of_lead, total_price, contract, project, unit_number, bua, outdoor_area, transaction_type, frowner, confirm, lastactionby, due_date, amount, bank, bankcheck, settlement, banker_id,client_name2,mobile_number2,client_name3,mobile_number3,client_name4,mobile_number4,client_name5,mobile_number5,client_name6,mobile_number6,incentive,incentive,total_commision_before_value_added_tax,value_added_tax,withholding_tax,net_commision,total_commision,status', 'length', 'max'=>255),
			array('details', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, date, time, company, sales, teamleader, manager, marketing, develpoer, request_id, details, resv_date, license, destinations, unit_type, client_name, mobile_number, current_address, job_title, email_address, source_of_lead, total_price, contract, project, unit_number, bua, outdoor_area, transaction_type, frowner, req_id, confirm, lastactionby, due_date, amount, bank, bankcheck, settlement, banker_id,status', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'date' => 'Date',
			'time' => 'Time',
			'company' => 'Company',
			'sales' => 'Sales',
			'teamleader' => 'Teamleader',
			'manager' => 'Manager',
			'marketing' => 'Marketing',
			'develpoer' => 'Develpoer',
			'request_id' => 'Request',
			'details' => 'Details',
			'resv_date' => 'Resv Date',
			'license' => 'License',
			'destinations' => 'Destinations',
			'unit_type' => 'Unit Type',
			'client_name' => 'Client Name',
			'mobile_number' => 'Mobile Number',
			'current_address' => 'Current Address',
			'job_title' => 'Job Title',
			'email_address' => 'Email Address',
			'source_of_lead' => 'Source Of Lead',
			'total_price' => 'Total Price',
			'contract' => 'Contract',
			'project' => 'Project',
			'unit_number' => 'Unit Number',
			'bua' => 'Bua',
			'outdoor_area' => 'Outdoor Area',
			'transaction_type' => 'Transaction Type',
			'frowner' => 'Frowner',
			'req_id' => 'Req',
			'confirm' => 'Confirm',
			'lastactionby' => 'Lastactionby',
			'due_date' => 'Due Date',
			'amount' => 'Amount',
			'bank' => 'Bank',
			'bankcheck' => 'Bankcheck',
			'settlement' => 'Settlement',
			'banker_id' => 'Banker',
			'incentive' => 'Incentive',
			
			
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('company',$this->company);
		$criteria->compare('sales',$this->sales,true);
		$criteria->compare('teamleader',$this->teamleader,true);
		$criteria->compare('manager',$this->manager,true);
		$criteria->compare('marketing',$this->marketing,true);
		$criteria->compare('develpoer',$this->develpoer,true);
		$criteria->compare('request_id',$this->request_id);
		$criteria->compare('details',$this->details,true);
		$criteria->compare('resv_date',$this->resv_date,true);
		$criteria->compare('license',$this->license,true);
		$criteria->compare('destinations',$this->destinations,true);
		$criteria->compare('unit_type',$this->unit_type,true);
		$criteria->compare('client_name',$this->client_name,true);
		$criteria->compare('mobile_number',$this->mobile_number,true);
		$criteria->compare('current_address',$this->current_address,true);
		$criteria->compare('job_title',$this->job_title);
		$criteria->compare('email_address',$this->email_address,true);
		$criteria->compare('source_of_lead',$this->source_of_lead,true);
		$criteria->compare('total_price',$this->total_price,true);
		$criteria->compare('contract',$this->contract,true);
		$criteria->compare('project',$this->project,true);
		$criteria->compare('unit_number',$this->unit_number,true);
		$criteria->compare('bua',$this->bua,true);
		$criteria->compare('outdoor_area',$this->outdoor_area,true);
		$criteria->compare('transaction_type',$this->transaction_type,true);
		$criteria->compare('frowner',$this->frowner,true);
		$criteria->compare('req_id',$this->req_id);
		$criteria->compare('confirm',$this->confirm,true);
		$criteria->compare('lastactionby',$this->lastactionby,true);
		$criteria->compare('due_date',$this->due_date,true);
		$criteria->compare('amount',$this->amount,true);
		$criteria->compare('bank',$this->bank,true);
		$criteria->compare('bankcheck',$this->bankcheck,true);
		$criteria->compare('settlement',$this->settlement,true);
		$criteria->compare('banker_id',$this->banker_id,true);
		$criteria->compare('incentive',$this->incentive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Tcr the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
