<?php

/**
 * This is the model class for table "transfer".
 *
 * The followings are the available columns in table 'transfer':
 * @property integer $id
 * @property integer $user_id
 * @property integer $fromm
 * @property integer $too
 * @property string $reason
 * @property string $date
 * @property string $time
 */
class Transfer extends CActiveRecord
{
    
    
    
      protected function beforeFind()
{
    // استدعاء الدالة الأصلية
    parent::beforeFind();

    // احصل على معرف المستخدم الحالي من الجلسة
    $currentUserId = Yii::app()->user->id;

    // تحقق من أن المعرف موجود
    if ($currentUserId) {
        // استعلام للحصول على جميع المعلومات من جدول المستخدمين بناءً على معرف المستخدم
        $userInfo = Yii::app()->db->createCommand()
            ->select('*') // اختر جميع الأعمدة أو الأعمدة التي تحتاجها فقط
            ->from('user') // اسم جدول المستخدمين
            ->where('id=:userId', array(':userId' => $currentUserId))
            ->queryRow();



        
        // Check if limitsformanager is not empty
        if (!empty($userInfo['limitsformanager'])) {
            
        $limitsArray = is_string($userInfo['limitsformanager']) ? explode(',', $userInfo['limitsformanager']) : $userInfo['limitsformanager'];
        // إضافة شرط الاستعلام بناءً على limitsformanager و currentUserId
        $this->getDbCriteria()->addCondition('too IN (' . implode(',', array_map('intval', $limitsArray)) . ') OR id = :userId');
        $this->getDbCriteria()->params[':userId'] = $currentUserId;    

        }

    return true; // تأكد من إرجاع true للسماح بمتابعة الاستعلام
}
}
    
    
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'transfer';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id, too, reason, date, time', 'required'),
			array('user_id, fromm, too,lead_id,transferaction_id,done,hide,fromstatus,tostatus,fromsubstatus,tosubstatus,hideteamleader,fakenewlead', 'numerical', 'integerOnly'=>true),
			array('reason', 'length', 'max'=>255),
			
						         	array( 'reason', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),

			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, fromm, too, reason, date, time,lead_id,transferaction_id,done,hide', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
'user1' => array(self::BELONGS_TO, 'User', 'user_id'),

'leads' => array(self::BELONGS_TO, 'Leads', 'lead_id'),
'employee1'    => array(self::BELONGS_TO, 'User',  'fromm'),
'employee2'    => array(self::BELONGS_TO, 'User',  'too'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'fromm' => 'Fromm',
			'too' => 'Too',
			'reason' => 'Reason',
			'date' => 'Date',
			'time' => 'Time',
			'lead_id' => 'Lead_id',
			'hide' => 'hide',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('lead_id',$this->lead_id);
		$criteria->compare('fromm',$this->fromm);
		$criteria->compare('too',$this->too);
		$criteria->compare('reason',$this->reason,true);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('hide',$this->hide,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Transfer the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
