<?php

/**
 * This is the model class for table "yearly_installments".
 *
 * The followings are the available columns in table 'yearly_installments':
 * @property integer $id
 * @property integer $user_id
 * @property integer $lead_id
 * @property string $date
 * @property string $time
 * @property integer $reservation_id
 * @property string $payment_date
 * @property integer $amount
 */
class YearlyInstallments extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'yearly_installments';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
		//	array('user_id, date, time, payment_date, amount', 'required'),
			array('user_id, lead_id, reservation_id, amount', 'numerical', 'integerOnly'=>true),

			
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, lead_id, date, time, reservation_id,service_id, payment_date, amount', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'lead_id' => 'Lead',
			'date' => 'Date',
			'time' => 'Time',
			'reservation_id' => 'Reservation',
	
			'service_id' => 'Service',
			'payment_date' => 'Payment Date',
			'amount' => 'Amount',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('lead_id',$this->lead_id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('reservation_id',$this->reservation_id);
		$criteria->compare('service_id',$this->service_id);
		$criteria->compare('payment_date',$this->payment_date,true);
		$criteria->compare('amount',$this->amount);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return YearlyInstallments the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
