<?php


	ini_set('max_execution_time', 300);
	ini_set('memory_limit', '-1');



	?>
	<div class="kt-portlet kt-portlet--height-fluid col-xl-12 col-md-12 col-lg-12" id="reportHolder">
		<div class="kt-portlet__head">
			<div class="kt-portlet__head-label">
				<h3 class="kt-portlet__head-title">
                    Cost of Goods Sold (COGS)/تكلفة المبيعات
                </h3>
			</div>
			<div class="kt-portlet__head-toolbar">
				<div class="kt-widget__action mr-1">
					<button type="button" class="btn btn-bold btn-label-brand btn-sm"  onclick="ExportExcel1('xlsx')">Excel</button>
				</div>
				<div class="kt-widget__action">
					<button type="button" class="btn btn-bold btn-label-brand btn-sm" id="pngReportButton">PNG</button>
				</div>
			</div>
		</div>
				<div class="kt-portlet__body">
					<!--Solid Form-->
					<div class="kt-portlet__body kt-portlet__body--fit"  >
<?php
// The SQL query to retrieve detailed Cost of Goods Sold (تكلفة المبيعات)
$sql = "
SELECT 
    fi_tree.title AS 'AccountTitle',
    fi_tree.code AS 'AccountCode',
    fi_tree.credit_balance_till AS 'Balance'
FROM 
    fi_tree
INNER JOIN 
    fi_main_tree ON fi_tree.main_tree_id = fi_main_tree.id
WHERE 
    fi_main_tree.id = 5  -- This ID corresponds to 'Expenses/Costs'
    AND (
        fi_tree.title LIKE 'المشتريات%'  -- Filters for 'Purchases' and related sub-accounts
    )
ORDER BY 
    fi_tree.code;
";

// Execute the query using Yii's database command
$command = Yii::app()->db->createCommand($sql);
$results = $command->queryAll();
// Initialize a variable to hold the total balance
$totalBalance = 0;


    // Start rendering the HTML table
    echo '<table border="1" class="table thead-light striped bordered condensed responsive dataTable">';
    echo '<thead>';
    echo '<tr>';
    echo '<th>Account Title</th>';
    echo '<th>Account Code</th>';
    echo '<th>Balance</th>';
    echo '</tr>';
    echo '</thead>';
    echo '<tbody>';
    
    // Loop through the results and display each row
    foreach ($results as $row) {
        echo '<tr>';
        echo '<td>' . CHtml::encode($row['AccountTitle']) . '</td>';
        echo '<td>' . CHtml::encode($row['AccountCode']) . '</td>';
        echo '<td>' . CHtml::encode($row['Balance']) . '</td>';
        echo '</tr>';
        
        // Accumulate the total balance
        $totalBalance += $row['Balance'];
    }

    // Display the total balance row
    echo '<tr>';
    echo '<td><strong>Total</strong></td>';
    echo '<td></td>';
    echo '<td><strong>' . CHtml::encode($totalBalance) . '</strong></td>';
    echo '</tr>';
    
    echo '</tbody>';
    echo '</table>';

?>

				</div>
			</div>
		</div>