<?php
// Use the actual project ID
$project_id = $project->id;

$list = Yii::app()->db->createCommand("
    SELECT
        p.title AS project_title,
        COUNT(*) AS total_units,
        SUM(CASE WHEN booking IS NULL THEN 1 ELSE 0 END) AS available_units,
        SUM(CASE WHEN booking IS NULL THEN u.total ELSE 0 END) AS available_units_price,
        SUM(CASE WHEN booking = 1 THEN 1 ELSE 0 END) AS reserved_units,
        SUM(CASE WHEN booking = 1 THEN u.soldprice ELSE 0 END) AS reserved_units_price,
        SUM(CASE WHEN booking = 2 THEN 1 ELSE 0 END) AS sold_units,
        SUM(CASE WHEN booking = 2 THEN u.soldprice ELSE 0 END) AS sold_units_price,
        SUM(CASE WHEN booking = 4 THEN 1 ELSE 0 END) AS held_units,
        SUM(CASE WHEN booking = 4 THEN u.total ELSE 0 END) AS held_units_price,
        SUM(CASE WHEN booking = 3 THEN 1 ELSE 0 END) AS blocked_units,
        SUM(CASE WHEN booking = 3 THEN u.total ELSE 0 END) AS blocked_units_price,
        SUM(CASE WHEN booking = 5 THEN 1 ELSE 0 END) AS off_units,
        SUM(CASE WHEN booking = 5 THEN u.total ELSE 0 END) AS off_units_price,
        SUM(CASE WHEN booking = 7 THEN 1 ELSE 0 END) AS pending_units,
        SUM(CASE WHEN booking = 7 THEN u.total ELSE 0 END) AS pending_units_price
    FROM units u
    JOIN projects p ON u.projects_id = p.id
    GROUP BY p.title
    WITH ROLLUP
")->queryAll();
?>
<div class="row">
<?php if(!empty($list)){
    foreach($list as $item) { ?>
<div class="col-md-4">  	
<!--begin::Portlet-->
<div class="kt-portlet">
	<div class="kt-portlet__head">
		<div class="kt-portlet__head-label">
			<h3 class="kt-portlet__head-title">
				<?php echo htmlspecialchars($item['project_title'] ?? 'Total'); ?>
			</h3>
		</div>
	</div>
	<div class="kt-portlet__body">
		<div class="kt-notification-v2">
			<a href="#" class="kt-notification-v2__item">
				<div class="kt-notification-v2__item-icon">
					<i class="flaticon-squares-2 kt-font-primary"></i>
				</div>
				<div class="kt-notification-v2__itek-wrapper">
					<div class="kt-notification-v2__item-title">
						<?php echo $item['total_units']; ?> Total Units
					</div>
				</div>
			</a>
			<a href="#" class="kt-notification-v2__item">
				<div class="kt-notification-v2__item-icon">
					<i class="flaticon-home-2 kt-font-info"></i>
				</div>
				<div class="kt-notification-v2__itek-wrapper">
					<div class="kt-notification-v2__item-title">
						<?php echo $item['available_units']; ?> Available Units
					</div>
					<div class="kt-notification-v2__item-desc solidmoney">
						Total Units Price: <?php echo $item['available_units_price']; ?>
					</div>
				</div>
			</a>
			<a href="#" class="kt-notification-v2__item">
				<div class="kt-notification-v2__item-icon">
					<i class="flaticon-home-1 kt-font-warning"></i>
				</div>
				<div class="kt-notification-v2__itek-wrapper">
					<div class="kt-notification-v2__item-title">
						<?php echo $item['reserved_units']; ?> Reserved Units
					</div>
					<div class="kt-notification-v2__item-desc solidmoney">
						Total Units Price: <?php echo $item['reserved_units_price']; ?>
					</div>
				</div>
			</a>
			<a href="#" class="kt-notification-v2__item">
				<div class="kt-notification-v2__item-icon">
					<i class="flaticon-home-1 kt-font-success"></i>
				</div>
				<div class="kt-notification-v2__itek-wrapper">
					<div class="kt-notification-v2__item-title">
						<?php echo $item['sold_units']; ?> Sold Units
					</div>
					<div class="kt-notification-v2__item-desc solidmoney">
						Total Units Price: <?php echo $item['sold_units_price']; ?>
					</div>
				</div>
			</a>
			<a href="#" class="kt-notification-v2__item">
				<div class="kt-notification-v2__item-icon">
					<i class="flaticon-home-1 kt-font-info"></i>
				</div>
				<div class="kt-notification-v2__itek-wrapper">
					<div class="kt-notification-v2__item-title">
						<?php echo $item['held_units']; ?> Hold Units
					</div>
					<div class="kt-notification-v2__item-desc solidmoney">
						Total Units Price: <?php echo $item['held_units_price']; ?>
					</div>
				</div>
			</a>
			<a href="#" class="kt-notification-v2__item">
				<div class="kt-notification-v2__item-icon">
					<i class="flaticon-home-1 kt-font-danger"></i>
				</div>
				<div class="kt-notification-v2__itek-wrapper">
					<div class="kt-notification-v2__item-title">
						<?php echo $item['blocked_units']; ?> Blocked Units
					</div>
					<div class="kt-notification-v2__item-desc solidmoney">
						Total Units Price: <?php echo $item['blocked_units_price']; ?>
					</div>
				</div>
			</a>
			<a href="#" class="kt-notification-v2__item">
				<div class="kt-notification-v2__item-icon">
					<i class="flaticon-home-1 kt-font-danger"></i>
				</div>
				<div class="kt-notification-v2__itek-wrapper">
					<div class="kt-notification-v2__item-title">
						<?php echo $item['off_units']; ?> Off Units
					</div>
					<div class="kt-notification-v2__item-desc solidmoney">
						Total Units Price: <?php echo $item['off_units_price']; ?>
					</div>
				</div>
			</a>
			<a href="#" class="kt-notification-v2__item">
				<div class="kt-notification-v2__item-icon">
					<i class="flaticon-home-1 kt-font-danger"></i>
				</div>
				<div class="kt-notification-v2__itek-wrapper">
					<div class="kt-notification-v2__item-title">
						<?php echo $item['pending_units']; ?> Pending Units
					</div>
					<div class="kt-notification-v2__item-desc solidmoney">
						Total Units Price: <?php echo $item['pending_units_price']; ?>
					</div>
				</div>
			</a>
		</div>
	</div>
</div>
<!--end::Portlet-->
</div>
<?php }  } ?>
		<script>
		    $(document).ready(function() {
                $('.solidmoney').each(function() {
                    const textContent = $(this).text().trim();
                    const number = parseInt(textContent.replace(/[^0-9]/g, ''), 10);
                    if (!isNaN(number)) {
                        $(this).text('EGP ' + formatMoney(number));
                    }
                });
            
                function formatMoney(number) {
                    return number.toLocaleString();
                }
            });
		</script>