<?php
// Use the actual project ID
$project_id = $project->id;

$list = Yii::app()->db->createCommand("
    SELECT
        'Total' AS project_title,
        SUM(total_units) AS total_units,
        SUM(available_units) AS available_units,
        SUM(available_units_price) AS available_units_price,
        SUM(reserved_units) AS reserved_units,
        SUM(reserved_units_price) AS reserved_units_price,
        SUM(sold_units) AS sold_units,
        SUM(sold_units_price) AS sold_units_price,
        SUM(held_units) AS held_units,
        SUM(held_units_price) AS held_units_price,
        SUM(blocked_units) AS blocked_units,
        SUM(blocked_units_price) AS blocked_units_price,
        SUM(off_units) AS off_units,
        SUM(off_units_price) AS off_units_price,
        SUM(pending_units) AS pending_units,
        SUM(pending_units_price) AS pending_units_price
    FROM (
        SELECT
            p.title AS project_title,
            COUNT(*) AS total_units,
            SUM(CASE WHEN booking IS NULL THEN 1 ELSE 0 END) AS available_units,
            SUM(CASE WHEN booking IS NULL THEN u.total ELSE 0 END) AS available_units_price,
            SUM(CASE WHEN booking = 1 THEN 1 ELSE 0 END) AS reserved_units,
            SUM(CASE WHEN booking = 1 THEN u.soldprice ELSE 0 END) AS reserved_units_price,
            SUM(CASE WHEN booking = 2 THEN 1 ELSE 0 END) AS sold_units,
            SUM(CASE WHEN booking = 2 THEN u.soldprice ELSE 0 END) AS sold_units_price,
            SUM(CASE WHEN booking = 4 THEN 1 ELSE 0 END) AS held_units,
            SUM(CASE WHEN booking = 4 THEN u.total ELSE 0 END) AS held_units_price,
            SUM(CASE WHEN booking = 3 THEN 1 ELSE 0 END) AS blocked_units,
            SUM(CASE WHEN booking = 3 THEN u.total ELSE 0 END) AS blocked_units_price,
            SUM(CASE WHEN booking = 5 THEN 1 ELSE 0 END) AS off_units,
            SUM(CASE WHEN booking = 5 THEN u.total ELSE 0 END) AS off_units_price,
            SUM(CASE WHEN booking = 7 THEN 1 ELSE 0 END) AS pending_units,
            SUM(CASE WHEN booking = 7 THEN u.total ELSE 0 END) AS pending_units_price
        FROM units u
        JOIN projects p ON u.projects_id = p.id
        GROUP BY p.title
    ) AS aggregated_data
")->queryAll();
?>
<?php $projectlist = Yii::app()->db->createCommand("SELECT id, title FROM projects;")->queryAll(); ?>

										<div class="kt-portlet__body kt-portlet__body--fit kt-portlet__body--unfill">
											<div class="kt-widget19__pic kt-portlet-fit--top kt-portlet-fit--sides" style="min-height: 300px; background-image: url(<?php echo Yii::app()->getBaseUrl(true) ?>/js/product3.jpg)">
												<h3 class="kt-widget19__title kt-font-light">
													Units Analyzes 
												</h3>
    											<div class="kt-portlet__head-toolbar" style="float: right;margin: 20px;">
    												<a href="#" class="btn btn-icon" data-toggle="dropdown">
    													<i class="flaticon-more-1 kt-font-light"></i>
    												</a>
    												<div class="dropdown-menu dropdown-menu-fit dropdown-menu-right" style="max-height: 200px; overflow-y: scroll;">
    													<ul class="kt-nav">
                                        		       <?php if(!empty($projectlist)) {
                                                            foreach($projectlist as $item) { ?>
                                        					<li class="kt-nav__item">
                                        						<a target="_blank" href="<?php echo Yii::app()->getBaseUrl(true) ?>/engineering/searchunits?booking=404&code=&projects=<?php echo CHtml::encode($item['id']); ?>&building=&activity=&floor_id=&indoor=&outdoor=&search=" class="kt-nav__link">
                                        							<i class="kt-nav__link-icon flaticon2-graph-1"></i>
                                        							<span class="kt-nav__link-text"><?php echo CHtml::encode($item['title']); ?></span>
                                        						</a>
                                        					</li>
                                                        <?php } } ?>
    													</ul>
    												</div>
    											</div>
												<div class="kt-widget19__shadow"></div>
												<div class="kt-widget19__labels">
													<a href="<?php echo Yii::app()->getBaseUrl(true) ?>/engineering/searchunits?booking=404&code=&projects=&building=&activity=&floor_id=&indoor=&outdoor=&search=" class="btn btn-label-light-o2 btn-bold kt-font-dark">Check All Units</a>
												</div>
											</div>
										</div>
										<div class="kt-portlet__body">
												<div class="kt-widget16">
												    <?php if(!empty($list)){
    foreach($list as $item) { ?>
													<div class="kt-widget16__items">
														<div class="kt-widget16__item">
															<span class="kt-widget16__sceduled">
																Units Type
															</span>
															<span class="kt-widget16__amount">
																Amount
															</span>
														</div>
														<div class="kt-widget16__item">
															<span class="kt-widget16__date">
															    <?php echo $item['available_units']; ?> Available Units
						                                    </span>
															<span class="kt-widget16__price solidmoney kt-font-primary">
																EGP <?php echo $item['available_units_price']; ?>
															</span>
														</div>
														<div class="kt-widget16__item">
															<span class="kt-widget16__date">								
                                    						    <?php echo $item['reserved_units']; ?> Reserved Units
                                    						</span>
															<span class="kt-widget16__price solidmoney kt-font-warning">
																EGP <?php echo $item['reserved_units_price']; ?>
															</span>
														</div>
														<div class="kt-widget16__item">
															<span class="kt-widget16__date">
															    <?php echo $item['sold_units']; ?> Sold Units
						                                    </span>
															<span class="kt-widget16__price solidmoney kt-font-success">
																EGP <?php echo $item['sold_units_price']; ?>
															</span>
														</div>
														<div class="kt-widget16__item">
															<span class="kt-widget16__date">
															    <?php echo $item['held_units']; ?> Hold Units
															</span>
															<span class="kt-widget16__price solidmoney kt-font-info">
																EGP <?php echo $item['held_units_price']; ?>
															</span>
														</div>
														<div class="kt-widget16__item">
															<span class="kt-widget16__date">
																<?php echo $item['blocked_units']; ?> Blocked Units
															</span>
															<span class="kt-widget16__price solidmoney kt-font-danger">
																EGP <?php echo $item['blocked_units_price']; ?>
															</span>
														</div>
														<div class="kt-widget16__item">
															<span class="kt-widget16__date">
																<?php echo $item['off_units']; ?> Off Units
															</span>
															<span class="kt-widget16__price solidmoney kt-font-danger">
																EGP <?php echo $item['off_units_price']; ?>
															</span>
														</div>
														<div class="kt-widget16__item">
															<span class="kt-widget16__date">
																<?php echo $item['pending_units']; ?> Pending Units
															</span>
															<span class="kt-widget16__price solidmoney kt-font-danger">
																EGP <?php echo $item['pending_units_price']; ?>
															</span>
														</div>
													</div>
<?php }  } ?>
												</div>
											</div>
		<script>
		    $(document).ready(function() {
                $('.solidmoney').each(function() {
                    const textContent = $(this).text().trim();
                    const number = parseInt(textContent.replace(/[^0-9]/g, ''), 10);
                    if (!isNaN(number)) {
                        $(this).text('EGP ' + formatMoney(number));
                    }
                });
            
                function formatMoney(number) {
                    return number.toLocaleString();
                }
            });
		</script>