<?php 
// Fetch static words by primary key
$allwords2 = Staticwords::model()->findByPk(2);

// Get current date and define the start and end of the month
$today = date("Y-m-d");
$start = date('Y-m-01');
$end = date('Y-m-t'); // 't' gives the number of days in the current month

// Get the current user ID
$userid = Yii::app()->user->id;

// Fetch all employees under the current leader
$allemployee = Teamleader::model()->findAll(array(
    'condition' => 'leader_id=' . (int)$userid, // Ensure safe casting to integer
    'order' => 'id DESC'
));

// Create an array of sales IDs for the employees under the leader
$arr = array();
foreach ($allemployee as $leader) {
    $arr[] = $leader->sales_id;
}

// Proceed if we have sales IDs to work with
if (!empty($arr)) {

    // Setup criteria for fetching leads
    $criteria = new CDbCriteria();         
    $criteria->condition = "coldcall IS NOT NULL"; // Only fetch records where coldcall is NOT NULL
    $criteria->addBetweenCondition("date", $start, $end); // Filter by date range
    $criteria->addInCondition('user_sales', $arr); // Filter by user sales IDs
    
    // Count all leads based on the criteria
    $allleads = Leads::model()->count($criteria);
    
    if (!empty($allleads)) { 
?>
        <a href="<?php echo Yii::app()->getBaseUrl(true) ?>/en/sales/searchsalesofleader?startdate=<?php echo $start; ?>&enddate=<?php echo $end; ?>&search=&team=&teamdistributed%5B%5D=&fb_id=&seaadsetnamerch=&adname=&internationalcode=&tel=&secondtel=&campaign%5B%5D=&usersales%5B%5D=<?php echo implode(',', $arr); ?>&platform%5B%5D=&platformchild%5B%5D=&status%5B%5D=&substatus%5B%5D=&place%5B%5D=&leadstate=&callcenter%5B%5D=&cold=1&yt0=Search" target="_blank" class="kt-widget17__item">
            <?php echo $allleads; ?>
        </a>
<?php 
    } else { 
?>
        0
<?php 
    } 
} else { 
?>
    0
<?php 
} 
?>
