<?php


	class PrinterController extends FrontController
	{
		
	/**
	* @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	* using two-column layout. See 'protected/views/layouts/column2.php'.
	*/
	 public $layout='//layouts/';

	/**
	* @return array action filters
	*/

	public function filters()
	{
		return array(
		'accessControl', // perform access control for CRUD operations
	);
	}


	public function actions()
	{
		return array(
			'captcha'=>array(
			'class'=>'CCaptchaAction',
			'backColor'=>0xFFFFFF,
			),
		);
	}



	public function actionLogout()
	{
		Yii::app()->user->logout();
		$this->redirect(array('home/index')	);
	}




 public function actionIndex()
	{
		if(Yii::app()->user->isMember())
		{
		$userid=Yii::app()->user->id;
		$this->render('dashboard',array(
		'userid'=>$userid ,
		));
	}
	

		else{

			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
			{
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm']))
			{
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
					$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->render('index',array('model'=>$model));
		}

	}
	


	

public function actionPrint($id)
	{
		if(Yii::app()->user->isMember())
		{
			

$userid=Yii::app()->user->id;
			$details = Bills::model()->findByAttributes(array('id'=>$id));
                        $allbillsitem = Billsitem::model()->findAll(array( 'condition' => 'bills_id=' . $details->id ,'order'=>'id DESC'  ));

     //$allbillsitemreplace = Billsitem::model()->findAll(array( 'condition' => 'bills_id =' . $details->bills_id ,'order'=>'id DESC'  ));

                        $instock = 1;
                        $criteria = new CDbCriteria();
                        $criteria->addSearchCondition('bills_id', $details->bills_id, false);
                        $criteria->addSearchCondition('instock', $instock, false);
		        $allbillsitemreplace = Billsitem::model()->findAll($criteria);
								
                        $allbills = Bills::model()->findAll(array( 'condition' => 'bills_id=' . $details->id ,'order'=>'id DESC'  ));

                        $allmade = Made::model()->findAll();
                        $allbrand = Brand::model()->findAll();
                        $allcolor = Color::model()->findAll();
                        $allshippingcompany = Shippingcompany::model()->findAll();
                        $allshippingarea = Shippingarea::model()->findAll();
                        $allshippingkg = Shippingkg::model()->findAll();
                        $allcode = Code::model()->findAll(array( 'order'=>'id DESC'  ));
                        $allCategory = Catgery::model()->findAll();
                        $allsize = Size::model()->findAll();

                        $today = date("Y-m-d");                     // 03.10.01
                        $time = date("H:i:s");                      // 17:16:18	

 
	

                      

                      

                        
			$this->render('print',array(
			'userid'=>$userid ,
                        'details'=>$details ,
                        'allbills'=>$allbills,
                        'allbrand'=>$allbrand,
                        'allcolor'=>$allcolor,
                        'allmade'=>$allmade,
                        'allcode'=>$allcode,
                        'allsize'=>$allsize,
                        'allCategory'=>$allCategory,
                        'allbillsitem'=>$allbillsitem,
                        'allbillsitemreplace'=>$allbillsitemreplace,
                        'allshippingcompany'=>$allshippingcompany ,
                        'allshippingarea'=>$allshippingarea ,
                        'allshippingkg'=>$allshippingkg,


                        
                      		
		     ));
	             }
	

		else{

			$model=new LoginForm;

			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
			{
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}

			// collect user input data
			if(isset($_POST['LoginForm']))
			{
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
					$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->render('index',array('model'=>$model));
		}

	}








public function actionPrintrevenues($id)
	{
		if(Yii::app()->user->isMember())
		{
			

			$details = Revenues::model()->findByAttributes(array('id'=>$id));
                      
                        
			$this->render('printrevenues',array(
			
                        'details'=>$details ,
                       

                        
                      		
		     ));
	             }
	

		else{

			$model=new LoginForm;

			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
			{
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}

			// collect user input data
			if(isset($_POST['LoginForm']))
			{
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
					$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->render('index',array('model'=>$model));
		}

	}






public function actionPrintexpenses($id)
	{
		if(Yii::app()->user->isMember())
		{
			

			$details = Expenses::model()->findByAttributes(array('id'=>$id));
                      
                        
			$this->render('printexpenses',array(
			
                        'details'=>$details ,
                       

                        
                      		
		     ));
	             }
	

		else{

			$model=new LoginForm;

			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
			{
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}

			// collect user input data
			if(isset($_POST['LoginForm']))
			{
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
					$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->render('index',array('model'=>$model));
		}

	}







public function actionSticker($id)
	{
		if(Yii::app()->user->isMember())
		{
			

                     $userid=Yii::app()->user->id;
		    $details = Products::model()->findByAttributes(array('id'=>$id));
                       
 
	

                      

                      

                        
			$this->render('sticker',array(
			'userid'=>$userid ,
                        'details'=>$details ,
                        


                        
                      		
		     ));
	             }
	

		else{

			$model=new LoginForm;

			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
			{
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}

			// collect user input data
			if(isset($_POST['LoginForm']))
			{
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
					$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->render('index',array('model'=>$model));
		}

	}








public function actionInventory()
		{
			if(Yii::app()->user->isMember())
			{
			$userid=Yii::app()->user->id;
 date_default_timezone_set('Africa/Cairo');  

                        $today = date("Y-m-d");                     // 03.10.01
                        $time = date("H:i:s");                      // 17:16:18	
	                $allmade = Made::model()->findAll();
                        $allbrand = Brand::model()->findAll();
                        $allcolor = Color::model()->findAll();
                        $allcode = Code::model()->findAll(array( 'order'=>'id DESC'  ));
                        $allgallery = Gallerybiblash::model()->findAll(array( 'limit'=>10, 'order'=>'id DESC' ));

            $criteria = new CDbCriteria;

            $total = Code::model()->count();

            $pages = new CPagination($total);
            $pages->pageSize = 500000;

            $pages->applyLimit($criteria);
 	    $criteria->order = 'id DESC';

            $posts = Code::model()->findAll($criteria);


                       

	

			$this->render('inventory',array(
			'userid'=>$userid ,
                        'allbrand'=>$allbrand,
                        'allcolor'=>$allcolor,
                        'allmade'=>$allmade,
                        'allcode'=>$allcode,
                        'posts' => $posts,
                        'pages' => $pages,
		
			));
		}
		

			else{
				$model=new LoginForm;
				// if it is ajax validation request
				if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
				{
					echo CActiveForm::validate($model);
					Yii::app()->end();
				}
				// collect user input data
				if(isset($_POST['LoginForm']))
				{
					$model->attributes=$_POST['LoginForm'];
					// validate user input and redirect to the previous page if valid
					if($model->validate() && $model->login())
						$this->redirect(array('login/index')	);
				}
				// display the login form
				$this->render('index',array('model'=>$model));
			}

		}












	
	
public function actionTest()
	{
		                    

 
	$criteria = new CDbCriteria;
            $total = Gallerybiblash::model()->count();
            $pages = new CPagination($total);
            $pages->pageSize = 30;
            $pages->applyLimit($criteria);
 
            $posts = Gallerybiblash::model()->findAll($criteria);

                      

                      

                        
			$this->render('test',array(
			
                        'posts' => $posts,
                        'pages' => $pages,		
		
			));
	             }
	

	








		

		
		
		
		
		
	
	
	

		


	
	

}