<?php
/**
 * This is the template for generating a controller class file for CRUD feature.
 * The following variables are available in this template:
 * - $this: the BootCrudCode object
 */
?>
<?php echo "<?php\n"; ?>

class <?php echo $this->controllerClass." extends AdminController \n"; ?>
{

/**
* @return array action filters
*/
public function filters()
{
	return array(
	'accessControl', // perform access control for CRUD operations
	);
}

/**
* Specifies the access control rules.
* This method is used by the 'accessControl' filter.
* @return array access control rules
*/
public function accessRules()
{
return array(

        array('allow', // allow authenticated users to perform any action
            'users'=>array('@'),
            'expression' => 'Yii::app()->user->isAdmin()',
        ),
        array('deny',  // deny all users
            'users'=>array('*'),
        ),
    );
}

/**
* Displays a particular model.
* @param integer $id the ID of the model to be displayed
*/
public function actionView($id)
{
	$this->adminMenu=array(
		array('label'=>'List <?php echo $this->pluralize($this->class2name($this->modelClass)); ?>','url'=>array('index')),
		array('label'=>'Create <?php echo $this->modelClass; ?>','url'=>array('create')),
		array('label'=>'Update <?php echo $this->modelClass; ?>','url'=>array('update','id'=>$id)),
		array('label'=>'Delete <?php echo $this->modelClass; ?>','url'=>'#','htmlOptions'=>array('submit'=>array('delete','id'=>$id),'confirm'=>'Are you sure you want to delete this item?')),
		);

	$this->render('view',array(
	'model'=>$this->loadModel($id),
	));
}

/**
* Creates a new model.
* If creation is successful, the browser will be redirected to the 'view' page.
*/
public function actionCreate()
{
	$model=new <?php echo $this->modelClass; ?>;

	$this->adminMenu=array(
	array('label'=>'List <?php echo $this->pluralize($this->class2name($this->modelClass)); ?>','url'=>array('index')),

	);

	// Uncomment the following line if AJAX validation is needed
	// $this->performAjaxValidation($model);

	if(isset($_POST['<?php echo $this->modelClass; ?>']))
	{
		$model->attributes=$_POST['<?php echo $this->modelClass; ?>'];
		if($model->save())
		$this->redirect(array('view','id'=>$model-><?php echo $this->tableSchema->primaryKey; ?>));
	}

	$this->render('create',array(
	'model'=>$model,
	));
}

/**
* Updates a particular model.
* If update is successful, the browser will be redirected to the 'view' page.
* @param integer $id the ID of the model to be updated
*/
public function actionUpdate($id)
{

	$model=$this->loadModel($id);

	$this->adminMenu=array(
		array('label'=>'List <?php echo $this->pluralize($this->class2name($this->modelClass)); ?>','url'=>array('index')),
		array('label'=>'Create <?php echo $this->modelClass; ?>','url'=>array('create')),
		array('label'=>'View <?php echo $this->modelClass; ?>','url'=>array('view','id'=>$model-><?php echo $this->tableSchema->primaryKey; ?>)),
		);

	// Uncomment the following line if AJAX validation is needed
	// $this->performAjaxValidation($model);

	if(isset($_POST['<?php echo $this->modelClass; ?>']))
	{
		$model->attributes=$_POST['<?php echo $this->modelClass; ?>'];
		if($model->save())
		$this->redirect(array('view','id'=>$model-><?php echo $this->tableSchema->primaryKey; ?>));
	}

	$this->render('update',array(
	'model'=>$model,
	));
}

/**
* Deletes a particular model.
* If deletion is successful, the browser will be redirected to the 'admin' page.
* @param integer $id the ID of the model to be deleted
*/
public function actionDelete($id)
{
	if(Yii::app()->request->isPostRequest)
	{
		// we only allow deletion via POST request
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
		$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('index'));
	}
	else
	throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
}


/**
* Manages all models.
*/
public function actionIndex()
{

	$model=new <?php echo $this->modelClass; ?>('search');

	$this->adminMenu=array(
		array('label'=>'Create <?php echo $this->modelClass; ?>','url'=>array('create')),
		);

	$model->unsetAttributes();  // clear any default values
	if(isset($_GET['<?php echo $this->modelClass; ?>']))
	$model->attributes=$_GET['<?php echo $this->modelClass; ?>'];

	$this->render('index',array(
	'model'=>$model,
));
}

/**
* Returns the data model based on the primary key given in the GET variable.
* If the data model is not found, an HTTP exception will be raised.
* @param integer the ID of the model to be loaded
*/
public function loadModel($id)
{
	$model=<?php echo $this->modelClass; ?>::model()->findByPk($id);
	if($model===null)
	throw new CHttpException(404,'The requested page does not exist.');
	return $model;
}

/**
* Performs the AJAX validation.
* @param CModel the model to be validated
*/
protected function performAjaxValidation($model)
{
	if(isset($_POST['ajax']) && $_POST['ajax']==='<?php echo $this->class2id($this->modelClass); ?>-form')
	{
		echo CActiveForm::validate($model);
		Yii::app()->end();
	}
}
}
