<?php

/**
 * This is the model class for table "action".
 *
 * The followings are the available columns in table 'action':
 * @property integer $id
 * @property integer $action_id
 * @property string $requirement
 * @property string $action_date
 * @property integer $data_id
 * @property integer $users_id
 * @property string $date
 * @property integer $assign_to
 * @property integer $status
 * @property string $notes
 */
class Action extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'action';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('action_id, requirement, action_date, data_id, users_id, date, assign_to, status, notes', 'required'),
			array('action_id, data_id, users_id, assign_to, status', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, action_id, requirement, action_date, data_id, users_id, date, assign_to, status, notes', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'action_id' => 'Action',
			'requirement' => 'Requirement',
			'action_date' => 'Action Date',
			'data_id' => 'Data',
			'users_id' => 'Users',
			'date' => 'Date',
			'assign_to' => 'Assign To',
			'status' => 'Status',
			'notes' => 'Notes',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('action_id',$this->action_id);
		$criteria->compare('requirement',$this->requirement,true);
		$criteria->compare('action_date',$this->action_date,true);
		$criteria->compare('data_id',$this->data_id);
		$criteria->compare('users_id',$this->users_id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('assign_to',$this->assign_to);
		$criteria->compare('status',$this->status);
		$criteria->compare('notes',$this->notes,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Action the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
