<?php

/**
 * This is the model class for table "area".
 *
 * The followings are the available columns in table 'area':
 * @property integer $id
 * @property integer $parent_id
 * @property integer $depth
 * @property string $title
 * @property string $secert
 * @property integer $hidden
 */
class Area extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'area';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
             array('title', 'unique',
                 'criteria' => array(
                     'condition' => 'parent_id = :parent_id AND hidden=1',
                     'params' => array(':parent_id' => $this->parent_id))),

			array('parent_id, secert, hidden', 'required'),
			array('parent_id, depth, hidden, user_id', 'numerical', 'integerOnly'=>true),
			array('title, secert, date, time', 'length', 'max'=>255),
			
		   array( 'title', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),

			
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, parent_id, depth, title, secert, hidden, user_id, date, time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(


'employee'    => array(self::BELONGS_TO, 'User',    'user_id'),		
'parent'    => array(self::BELONGS_TO, 'Area',    'parent_id'),		


		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'parent_id' => 'Parent',
'user_id' => 'User',
'date' => 'Date',
'time' => 'Time',
			'depth' => 'Depth',
			'title' => 'Title',
			'secert' => 'Secert',
			'hidden' => 'Hidden',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('parent_id',$this->parent_id);
		$criteria->compare('depth',$this->depth);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('secert',$this->secert,true);
		$criteria->compare('hidden',$this->hidden);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Area the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}


}
