<?php

/**
 * This is the model class for table "broker_leads".
 *
 * The followings are the available columns in table 'broker_leads':
 * @property integer $id
 * @property integer $user_id
 * @property string $date
 * @property string $time
 * @property string $name
 * @property string $mobile
 * @property integer $company_id
 * @property integer $international_code
 * @property string $secert
 * @property string $details
 * @property integer $hidden
 * @property integer $user_sales
 * @property string $building
 * @property string $unit
 * @property string $total
 * @property string $payment
 * @property string $installments
 * @property string $dateofcontract
 */
class BrokerLeads extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'broker_leads';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id, date, time, name, mobile, company_id, secert, hidden', 'required'),
			array('user_id, company_id, international_code, hidden, user_sales', 'numerical', 'integerOnly'=>true),
			array('name, secert, building, unit, total, payment, installments, mobile', 'length', 'max'=>255),
			//array('mobile', 'length', 'max'=>15),
			array('dateofcontract', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, date, time, name, mobile, mobile2, company_id, international_code, secert, details, hidden, user_sales, building, unit, total, payment, installments, dateofcontract', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */


	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(

		'employee'    => array(self::BELONGS_TO, 'User',    'user_id'),
		'company'    => array(self::BELONGS_TO, 'Company',    'company_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'date' => 'Date',
			'time' => 'Time',
			'name' => 'Name',
			'mobile' => 'Mobile',
			'mobile2' => 'Mobile2',

			'company_id' => 'Company',
			'international_code' => 'International Code',
			'secert' => 'Secert',
			'details' => 'Details',
			'hidden' => 'Hidden',
			'user_sales' => 'User Sales',
			'building' => 'Building',
			'unit' => 'Unit',
			'total' => 'Total',
			'payment' => 'Payment',
			'installments' => 'Installments',
			'dateofcontract' => 'Dateofcontract',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('mobile',$this->mobile,true);
		$criteria->compare('company_id',$this->company_id);
		$criteria->compare('international_code',$this->international_code);
		$criteria->compare('secert',$this->secert,true);
		$criteria->compare('details',$this->details,true);
		$criteria->compare('hidden',$this->hidden);
		$criteria->compare('user_sales',$this->user_sales);
		$criteria->compare('building',$this->building,true);
		$criteria->compare('unit',$this->unit,true);
		$criteria->compare('total',$this->total,true);
		$criteria->compare('payment',$this->payment,true);
		$criteria->compare('installments',$this->installments,true);
		$criteria->compare('dateofcontract',$this->dateofcontract,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return BrokerLeads the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
