<?php

/**
 * This is the model class for table "building".
 *
 * The followings are the available columns in table 'building':
 * @property integer $id
 * @property string $title
 * @property integer $user_id
 * @property string $date
 * @property string $time
 * @property integer $projects_id
 * @property integer $size_buliding
 * @property integer $size_buliding_net
 * @property integer $elevator
 * @property integer $floor_start
 * @property integer $floor_end
 * @property integer $number_area
 * @property integer $neighboring_area
 * @property integer $area_area
 * @property string $delivery_date
 * @property integer $number_units
 * @property integer $number_roles
 * @property integer $sold_units
 * @property integer $reserved_units
 * @property integer $remaning_units
 * @property string $details
 * @property string $latiude
 * @property string $longitude
 * @property integer $status
 * @property string $secert
 * @property integer $hidden
 */
class Building extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'building';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(

			//array('user_id, date, time, projects_id, secert, hidden', 'required'),
			array('user_id, projects_id,  elevator, floor_start, floor_end, number_units, tree_id, number_roles, sold_units, reserved_units, remaning_units, status, hidden, toilets, internet, conditioning, extinguishingnetwork, firealarm, securitycameras, securityguards, additionalpositions, restaurants, bankingservices,bulding_number', 'numerical', 'integerOnly'=>true),
			array('size_buliding, number_area, size_buliding_net ,percentage_construction,sort', 'numerical'),
			array('title,  neighboring_area, area_area, latiude, longitude, secert, activity,upload', 'length', 'max'=>255),
			array('delivery_date, details', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, title, user_id, date, time, projects_id, size_buliding, size_buliding_net, elevator, tree_id, floor_start, floor_end, number_area, neighboring_area, area_area, delivery_date, number_units, number_roles, sold_units, reserved_units,sort, remaning_units, details, latiude, longitude, status, secert, hidden, activity, toilets, internet, conditioning, extinguishingnetwork, firealarm, securitycameras, securityguards, additionalpositions, restaurants, bankingservices', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		
'neighbor'    => array(self::BELONGS_TO, 'Area',    'neighboring_area'),
'project'    => array(self::BELONGS_TO, 'Projects',    'projects_id'),
'employee'    => array(self::BELONGS_TO, 'User',    'user_id'),
'floorstart'    => array(self::BELONGS_TO, 'Floor',    'floor_start'),	
'floorend'    => array(self::BELONGS_TO, 'Floor',    'floor_end'),
'xactivity'    => array(self::BELONGS_TO, 'TypeBuliding',    'activity'),		
		
	
		
		
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'title' => 'Title',
			'user_id' => 'User',
			'date' => 'Date',
			'time' => 'Time',
			'projects_id' => 'Projects',
			'size_buliding' => 'Size Buliding',
                        'percentage_construction' => 'Percentage Construction',
			'size_buliding_net' => 'Size Buliding Net',
			'elevator' => 'Elevator',
			'floor_start' => 'Floor Start',
			'floor_end' => 'Floor End',
			'number_area' => 'Plot. No.',
			'neighboring_area' => 'Neighboring Area',
			'area_area' => 'Zone',
			'delivery_date' => 'Delivery Date',
			'number_units' => 'Number Units',
			'number_roles' => 'Number Floors',
			'sold_units' => 'Sold Units',
			'reserved_units' => 'Reserved Units',
			'remaning_units' => 'Remaning Units',
			'details' => 'Details',
			'latiude' => 'Latiude',
			'longitude' => 'Longitude',
			'status' => 'Status',
			'secert' => 'Secert',
			'hidden' => 'Hidden',
			'activity' => 'Activity',
			'sort' => 'Sort',

		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
{
    $criteria = new CDbCriteria;

    // Apply filters and conditions as usual
    $criteria->addSearchCondition('hidden', 1, false);
    if (!empty($_REQUEST['project'])) {
        $criteria->addSearchCondition('projects_id', $_REQUEST['project'], false, "AND");
    }
    $criteria->compare('title', $this->title);
    $criteria->compare('date', $this->date);
    $criteria->compare('time', $this->time);
    $criteria->compare('projects_id', $this->projects_id);
    $criteria->compare('activity', $this->activity);
    $criteria->compare('id', $this->id);

    // Retrieve all data as an array
    $allBuildings = Building::model()->findAll($criteria);

    // Sort array by title using natural order
    usort($allBuildings, function($a, $b) {
        return strnatcmp($a->title, $b->title);
    });

    // Convert sorted array to CArrayDataProvider
    $dataProvider = new CArrayDataProvider($allBuildings, array(
        'pagination' => array('pageSize' => Yii::app()->user->getState('pageSize', Yii::app()->params['defaultPageSize'])),
    ));

    return $dataProvider;
}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Building the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
