<?php

/**
 * This is the model class for table "cil_log".
 *
 * The followings are the available columns in table 'cil_log':
 * @property integer $id
 * @property integer $userid
 * @property string $date
 * @property string $renewaldate
 * @property string $time
 * @property integer $company_id
 * @property integer $profile_id
 * @property integer $done
 */
class CilLog extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'cil_log';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('userid, date, time, company_id, profile_id', 'required'),
			array('userid, company_id, profile_id, done', 'numerical', 'integerOnly'=>true),
			array('renewaldate', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, userid, date, renewaldate, time, company_id, profile_id, done', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    
		'employee'    => array(self::BELONGS_TO, 'User',    'userid'),
		
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'userid' => 'Userid',
			'date' => 'Date',
			'renewaldate' => 'Renewaldate',
			'time' => 'Time',
			'company_id' => 'Company',
			'profile_id' => 'Profile',
			'done' => 'Done',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('userid',$this->userid);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('renewaldate',$this->renewaldate,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('company_id',$this->company_id);
		$criteria->compare('profile_id',$this->profile_id);
		$criteria->compare('done',$this->done);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return CilLog the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
