<?php

/**
 * This is the model class for table "deleteleads".
 *
 * The followings are the available columns in table 'deleteleads':
 * @property integer $id
 * @property integer $user_id
 * @property string $date
 * @property string $time
 * @property integer $lead_id
 * @property string $tel
 * @property string $title
 * @property integer $user_sales
 * @property integer $camp_id
 * @property integer $platform_id
 * @property string $details
 */
class Deleteleads extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'deleteleads';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('date, time, lead_id', 'required'),
			array('user_id, lead_id, user_sales, camp_id, platform_id', 'numerical', 'integerOnly'=>true),
			array('tel, title', 'length', 'max'=>255),
			array('details', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, date, time, lead_id, tel, title, user_sales, camp_id, platform_id, details', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'date' => 'Date',
			'time' => 'Time',
			'lead_id' => 'Lead',
			'tel' => 'Tel',
			'title' => 'Title',
			'user_sales' => 'User Sales',
			'camp_id' => 'Camp',
			'platform_id' => 'Platform',
			'details' => 'Details',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('lead_id',$this->lead_id);
		$criteria->compare('tel',$this->tel,true);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('user_sales',$this->user_sales);
		$criteria->compare('camp_id',$this->camp_id);
		$criteria->compare('platform_id',$this->platform_id);
		$criteria->compare('details',$this->details,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Deleteleads the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
