<?php

/**
 * This is the model class for table "editlog".
 *
 * The followings are the available columns in table 'editlog':
 * @property integer $id
 * @property string $date
 * @property string $time
 * @property integer $lead_id
 * @property integer $user_id
 * @property string $editfrom
 * @property string $editto
 * @property string $editcolumn
 */
class Editlog extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'editlog';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('date, time', 'required'),
			array('lead_id, user_id,broker_id', 'numerical', 'integerOnly'=>true),
			array('editcolumn', 'length', 'max'=>255),
			array('editfrom, editto', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, date, time, lead_id, user_id, editfrom, editto, editcolumn,broker_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    
		    		'employee'    => array(self::BELONGS_TO, 'User',    'user_id'),

		    
		    
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'date' => 'Date',
			'time' => 'Time',
			'lead_id' => 'Lead',
			'user_id' => 'User',
			'editfrom' => 'Editfrom',
			'editto' => 'Editto',
			'editcolumn' => 'Editcolumn',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('lead_id',$this->lead_id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('editfrom',$this->editfrom,true);
		$criteria->compare('editto',$this->editto,true);
		$criteria->compare('editcolumn',$this->editcolumn,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Editlog the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
