<?php

/**
 * This is the model class for table "eoiform".
 *
 * The followings are the available columns in table 'eoiform':
 * @property integer $id
 * @property string $date
 * @property string $title
 * @property string $tel
 * @property string $codeid
 * @property string $nationality
 * @property string $address
 * @property string $email
 * @property string $unit_type
 * @property double $amount
 * @property string $amount_type
 * @property string $from_id
 * @property integer $code
 * @property string $con_date
 * @property string $time
 * @property integer $lead_id
 * @property integer $user_id
 * @property string $secert
 * @property integer $done
 * @property string $details
 * @property string $broker
 * @property string $project
 * @property integer $active
 */
class Eoiform extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'eoiform';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
		   // array('done','unique'),

			array('code, lead_id, user_id, done, active,accepted,rejected,delete,unit_id ,codeen', 'numerical', 'integerOnly'=>true),
			array('amount, autocode', 'numerical'),
			array('title, tel, codeid, nationality, address, email,object_id, unit_type, amount_type, from_id, secert, broker, project,area,sales,othersales,thirdsales,teamleader,building,floor,job,titleen,telen,codeiden,nationalityen,addressen,brokeren,areaen,joben,salesen,teamleaderen,teamleaderbrokeren,passport', 'length', 'max'=>255),
			array('date, con_date, time, details', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, date, title, tel, codeid, nationality, address, email, unit_type, amount, amount_type, from_id, code, con_date, time, lead_id, user_id, secert, done, details, broker, project, active, autocode,area,teamleader,titleen,telen,codeiden,nationalityen,addressen,brokeren,areaen,joben,salesen,teamleaderen,teamleaderbrokeren ,codeen,amounten,detailsen,amount_typeen,passport', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'date' => 'Date',
			'title' => 'Title',
			'tel' => 'Tel',
			'codeid' => 'Codeid',
			'nationality' => 'Nationality',
			'address' => 'Address',
			'email' => 'Email',
			'unit_type' => 'Unit Type',
			'amount' => 'Amount',
			'amount_type' => 'Amount Type',
			'from_id' => 'From',
			'code' => 'Code',
			'con_date' => 'Con Date',
			'time' => 'Time',
			'lead_id' => 'Lead',
			'user_id' => 'User',
			'secert' => 'Secert',
			'done' => 'Done',
			'details' => 'Details',
			'broker' => 'Broker',
			'project' => 'Project',
			'active' => 'Active',
			'autocode' => 'Autocode',

			
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('tel',$this->tel,true);
		$criteria->compare('codeid',$this->codeid,true);
		$criteria->compare('nationality',$this->nationality,true);
		$criteria->compare('address',$this->address,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('unit_type',$this->unit_type,true);
		$criteria->compare('amount',$this->amount);
		$criteria->compare('amount_type',$this->amount_type,true);
		$criteria->compare('from_id',$this->from_id,true);
		$criteria->compare('code',$this->code);
		$criteria->compare('con_date',$this->con_date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('lead_id',$this->lead_id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('secert',$this->secert,true);
		$criteria->compare('done',$this->done);
		$criteria->compare('details',$this->details,true);
		$criteria->compare('broker',$this->broker,true);
		$criteria->compare('project',$this->project,true);
		$criteria->compare('active',$this->active);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Eoiform the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
