<?php

/**
 * This is the model class for table "fi_generalledger".
 *
 * The followings are the available columns in table 'fi_generalledger':
 * @property integer $id
 * @property string $date
 * @property string $time
 * @property integer $user_id
 * @property integer $tree_id
 * @property integer $type_id
 * @property string $details
 * @property double $amount
 * @property double $credit_balance
 * @property integer $generalledgergroup_id
 * @property integer $financial_year_id
 * @property integer $financial_year_other
 */
class FiGeneralledger extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'fi_generalledger';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('date, time, user_id, tree_id, details, amount', 'required'),
			array('user_id, tree_id, type_id, generalledgergroup_id, financial_year_id, financial_year_other,main_tree_id,screen', 'numerical', 'integerOnly'=>true),
			array('amount, credit_balance', 'numerical'),
			array('details,financialcenter', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, date, time, user_id, tree_id, type_id, details, amount, credit_balance, generalledgergroup_id, financial_year_id, financial_year_other,main_tree_id,financialcenter', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'date' => 'Date',
			'time' => 'Time',
			'user_id' => 'User',
			'tree_id' => 'Tree',
			'type_id' => 'Type',
			'details' => 'Details',
			'amount' => 'Amount',
			'credit_balance' => 'Credit Balance',
			'generalledgergroup_id' => 'Generalledgergroup',
			'financial_year_id' => 'Financial Year',
			'financial_year_other' => 'Financial Year Other',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('tree_id',$this->tree_id);
		$criteria->compare('type_id',$this->type_id);
		$criteria->compare('details',$this->details,true);
		$criteria->compare('amount',$this->amount);
		$criteria->compare('credit_balance',$this->credit_balance);
		$criteria->compare('generalledgergroup_id',$this->generalledgergroup_id);
		$criteria->compare('financial_year_id',$this->financial_year_id);
		$criteria->compare('financial_year_other',$this->financial_year_other);	
      	
        $sort = new CSort();
        $criteria->order = Yii::app()->request->getParam('sort'); 
        $sort->attributes = array(
            'id'=>array(
                'asc'=>'id ASC',
                'desc'=>'id DESC',
            ),
            'date'=>array(
                'asc'=>'date ASC',
                'desc'=>'date DESC',
            ),
            'time'=>array(
                'asc'=>'time ASC',
                'desc'=>'time DESC',
            ),
            'tree_id'=>array(
                'asc'=>'tree_id ASC',
                'desc'=>'tree_id DESC',
            ),
            'user_id'=>array(
                'asc'=>'user_id ASC',
                'desc'=>'user_id DESC',
            ),
            'type_id'=>array(
                'asc'=>'type_id ASC',
                'desc'=>'type_id DESC',
            ),
            'details'=>array(
                'asc'=>'details ASC',
                'desc'=>'details DESC',
            ),
            'amount'=>array(
                'asc'=>'amount ASC',
                'desc'=>'amount DESC',
            ),
            'credit_balance'=>array(
                'asc'=>'credit_balance ASC',
                'desc'=>'credit_balance DESC',
            ),
            'generalledgergroup_id'=>array(
                'asc'=>'generalledgergroup_id ASC',
                'desc'=>'generalledgergroup_id DESC',
            ),
            'financial_year_id'=>array(
                'asc'=>'financial_year_id ASC',
                'desc'=>'financial_year_id DESC',
            ),
            'financial_year_other'=>array(
                'asc'=>'financial_year_other ASC',
                'desc'=>'financial_year_other DESC',
            ),
            '*', 
        );
 
		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		     'sort' => $sort,
		));
	}
	

	







	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return FiGeneralledger the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
