<?php

/**
 * This is the model class for table "fi_screens".
 *
 * The followings are the available columns in table 'fi_screens':
 * @property integer $id
 * @property integer $user_id
 * @property string $date
 * @property string $time
 * @property string $title
 * @property string $intro
 * @property integer $debit_tree_id
 * @property integer $credit_tree_id
 * @property string $details
 * @property string $access_id
 */
class FiScreens extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'fi_screens';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id, date, time, title, debit_tree_id, credit_tree_id', 'required'),
			array('user_id, debit_tree_id, credit_tree_id', 'numerical', 'integerOnly'=>true),
			array('title, intro, access_id,icons', 'length', 'max'=>255),
			array('details', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, date, time, title, intro, debit_tree_id, credit_tree_id, details, access_id,icons', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    
        'debit'    => array(self::BELONGS_TO, 'FiTree',    'debit_tree_id'),
        'credit'    => array(self::BELONGS_TO, 'FiTree',    'credit_tree_id'),
        

		    
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'date' => 'Date',
			'time' => 'Time',
			'title' => 'Title',
			'intro' => 'Intro',
			'debit_tree_id' => 'Debit Tree',
			'credit_tree_id' => 'Credit Tree',
			'details' => 'Details',
			'access_id' => 'Access',
		    'icons' => 'Icons',

			
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('intro',$this->intro,true);
		$criteria->compare('debit_tree_id',$this->debit_tree_id);
		$criteria->compare('credit_tree_id',$this->credit_tree_id);
		$criteria->compare('details',$this->details,true);
		$criteria->compare('access_id',$this->access_id,true);
		$criteria->compare('icons',$this->icons,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return FiScreens the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
