<?php

/**
 * This is the model class for table "historyofqty".
 *
 * The followings are the available columns in table 'historyofqty':
 * @property integer $id
 * @property string $date
 * @property string $time
 * @property double $qty
 * @property integer $evaluation_id
 * @property string $details
 * @property string $voucher_date
 * @property integer $user_id
 * @property integer $supplier_id
 */
class Historyofqty extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'historyofqty';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			//array('date, time, qty, evaluation_id, details, voucher_date, user_id, supplier_id', 'required'),
			array('evaluation_id, user_id, supplier_id', 'numerical', 'integerOnly'=>true),
			array('qty', 'numerical'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, date, time, qty, evaluation_id, details, voucher_date, user_id, supplier_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'date' => 'Date',
			'time' => 'Time',
			'qty' => 'Qty',
			'evaluation_id' => 'Evaluation',
			'details' => 'Details',
			'voucher_date' => 'Voucher Date',
			'user_id' => 'User',
			'supplier_id' => 'Supplier',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('qty',$this->qty);
		$criteria->compare('evaluation_id',$this->evaluation_id);
		$criteria->compare('details',$this->details,true);
		$criteria->compare('voucher_date',$this->voucher_date,true);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('supplier_id',$this->supplier_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Historyofqty the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
