<?php

/**
 * This is the model class for table "material_transfer".
 *
 * The followings are the available columns in table 'material_transfer':
 * @property integer $id
 * @property string $date
 * @property string $time
 * @property integer $user_id
 * @property integer $from_stock_id
 * @property integer $to_stock_id
 * @property integer $purchasing_order_product_id
 * @property integer $qty
 * @property string $details
 */
class MaterialTransfer extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'material_transfer';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('date, time, user_id, from_stock_id, to_stock_id, purchasing_order_product_id, qty', 'required'),
			array('user_id, from_stock_id, to_stock_id, purchasing_order_product_id, qty', 'numerical', 'integerOnly'=>true),
			array('details', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, date, time, user_id, from_stock_id, to_stock_id, purchasing_order_product_id, qty, details', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'date' => 'Date',
			'time' => 'Time',
			'user_id' => 'User',
			'from_stock_id' => 'From Stock',
			'to_stock_id' => 'To Stock',
			'purchasing_order_product_id' => 'Purchasing Order Product',
			'qty' => 'Qty',
			'details' => 'Details',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('from_stock_id',$this->from_stock_id);
		$criteria->compare('to_stock_id',$this->to_stock_id);
		$criteria->compare('purchasing_order_product_id',$this->purchasing_order_product_id);
		$criteria->compare('qty',$this->qty);
		$criteria->compare('details',$this->details,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MaterialTransfer the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
