<?php

/**
 * This is the model class for table "request".
 *
 * The followings are the available columns in table 'request':
 * @property integer $id
 * @property integer $user_id
 * @property string $date
 * @property string $time
 * @property integer $lead_id
 * @property integer $lead_type
 * @property string $name
 * @property string $tel
 * @property integer $status
 * @property integer $substatus
 * @property integer $classification
 * @property integer $request
 * @property integer $city
 * @property string $address
 * @property string $project
 * @property integer $unit_type
 * @property integer $floor
 * @property integer $built_up_area
 * @property integer $land_area
 * @property integer $bedrooms
 * @property integer $bathrooms
 * @property integer $budget_form
 * @property integer $budget_to
 * @property integer $request_status
 * @property integer $request_rate
 * @property integer $payment_method
 * @property integer $payment_status
 * @property integer $finishing
 * @property string $notes
 * @property integer $furniture
 */
class Request extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'request';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id, date, time', 'required'),
			array('user_id, lead_id, lead_type, status, substatus, classification, request, city, unit_type, floor, built_up_area, land_area, bedrooms, bathrooms, budget_form, budget_to, request_status, request_rate, payment_method, payment_status, finishing, furniture', 'numerical', 'integerOnly'=>true),
			array('name, tel, project', 'length', 'max'=>255),
			array('address, notes, url', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, date, time, lead_id, lead_type, name, tel, status, substatus, classification, request, city, address, project, unit_type, floor, built_up_area, land_area, bedrooms, bathrooms, budget_form, budget_to, request_status, request_rate, payment_method, payment_status, finishing, notes, furniture, url', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'date' => 'Date',
			'time' => 'Time',
			'lead_id' => 'Lead',
			'lead_type' => 'Lead Type',
			'name' => 'Name',
			'tel' => 'Tel',
			'status' => 'Status',
			'substatus' => 'Substatus',
			'classification' => 'Classification',
			'request' => 'Request',
			'city' => 'City',
			'address' => 'Address',
			'project' => 'Project',
			'unit_type' => 'Unit Type',
			'floor' => 'Floor',
			'built_up_area' => 'Built Up Area',
			'land_area' => 'Land Area',
			'bedrooms' => 'Bedrooms',
			'bathrooms' => 'Bathrooms',
			'budget_form' => 'Budget Form',
			'budget_to' => 'Budget To',
			'request_status' => 'Request Status',
			'request_rate' => 'Request Rate',
			'payment_method' => 'Payment Method',
			'payment_status' => 'Payment Status',
			'finishing' => 'Finishing',
			'notes' => 'Notes',
			'furniture' => 'Furniture',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('lead_id',$this->lead_id);
		$criteria->compare('lead_type',$this->lead_type);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('tel',$this->tel,true);
		$criteria->compare('status',$this->status);
		$criteria->compare('substatus',$this->substatus);
		$criteria->compare('classification',$this->classification);
		$criteria->compare('request',$this->request);
		$criteria->compare('city',$this->city);
		$criteria->compare('address',$this->address,true);
		$criteria->compare('project',$this->project,true);
		$criteria->compare('unit_type',$this->unit_type);
		$criteria->compare('floor',$this->floor);
		$criteria->compare('built_up_area',$this->built_up_area);
		$criteria->compare('land_area',$this->land_area);
		$criteria->compare('bedrooms',$this->bedrooms);
		$criteria->compare('bathrooms',$this->bathrooms);
		$criteria->compare('budget_form',$this->budget_form);
		$criteria->compare('budget_to',$this->budget_to);
		$criteria->compare('request_status',$this->request_status);
		$criteria->compare('request_rate',$this->request_rate);
		$criteria->compare('payment_method',$this->payment_method);
		$criteria->compare('payment_status',$this->payment_status);
		$criteria->compare('finishing',$this->finishing);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('furniture',$this->furniture);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Request the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
