<?php

/**
 * This is the model class for table "translations".
 *
 * The followings are the available columns in table 'translations':
 * @property integer $id
 * @property string $table_name
 * @property integer $model_id
 * @property string $attribute
 * @property string $lang
 * @property string $value
 */
class Translations extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'translations';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('table_name, model_id, attribute, lang, value', 'required'),
			array('model_id', 'numerical', 'integerOnly'=>true),
			array('table_name, attribute', 'length', 'max'=>100),
			array('lang', 'length', 'max'=>6),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, table_name, model_id, attribute, lang, value', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'table_name' => 'Table Name',
			'model_id' => 'Model',
			'attribute' => 'Attribute',
			'lang' => 'Lang',
			'value' => 'Value',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('table_name',$this->table_name,true);
		$criteria->compare('model_id',$this->model_id);
		$criteria->compare('attribute',$this->attribute,true);
		$criteria->compare('lang',$this->lang,true);
		$criteria->compare('value',$this->value,true);

		return new CActiveDataProvider($this, array(
	        'pagination' => array(
	             'pageSize' => 25,
	        ),
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Translations the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	public function getAll()
	{
		return CHtml::listData(self::model()->findAll(), 'id');
	}
}
