<?php

/**
 * This is the model class for table "treeaccount".
 *
 * The followings are the available columns in table 'treeaccount':
 * @property integer $id
 * @property string $title
 * @property string $date
 * @property string $time
 * @property integer $user_id
 * @property string $code
 * @property string $results
 * @property integer $parent_id
 * @property string $description
 * @property integer $has_child
 */
class Treeaccount extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'treeaccount';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
		array('code','unique'),
			array('date, time, user_id, code, parent_id', 'required'),
			array('user_id,code, parent_id, has_child, branch_id,status,percentage,place,initialbalance,level,state', 'numerical', 'integerOnly'=>true),
			array('title, results,lead_id', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, title, date, time, user_id, code, results, parent_id, description, has_child, branch_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    
		'parent'    => array(self::BELONGS_TO, 'Treeaccount',    'parent_id'),
		
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'title' => 'Title',
			'date' => 'Date',
			'time' => 'Time',
			'user_id' => 'User',
			'code' => 'Code',
			'results' => 'Results',
			'parent_id' => 'Parent',
			'description' => 'Description',
			'has_child' => 'Has Child',
			'branch_id' => 'Branch',
			'initialbalance' => 'Initialbalance',
			
			

		
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	 
	 
	 
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('code',$this->code,true);
		$criteria->compare('results',$this->results,true);
		$criteria->compare('parent_id',$this->parent_id);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('has_child',$this->has_child);
		$criteria->compare('branch_id',$this->branch_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Treeaccount the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	
	
	public function getChildrenString($parent) { 
        $criteria = new CDbCriteria;
        $criteria->condition='parent_id=:id';
        $criteria->params=array(':id'=>$parent);
        $model = Treeaccount::model()->findAll($criteria);
        $arr[]=1;
        foreach ($model as $key) {
            $arr[]= $key->id ; 
            $arr[]= $this->getChildrenString($key->id);
        }
        return $arr;
    }

public function arrayflatten($array) {
  if (!is_array($array)) {
    return FALSE;
  }
  $result = array();
  foreach ($array as $key => $value) {
    if (is_array($value)) {
      $result = array_merge($result, $this->arrayflatten($value));
    }
    else {
      $result[$key] = $value;
    }
  }
  return $result;
}


}
