<?php

/**
 * This is the model class for table "visit".
 *
 * The followings are the available columns in table 'visit':
 * @property integer $id
 * @property integer $user_id
 * @property integer $lead_id
 * @property string $date
 * @property string $details
 * @property string $reason
 * @property integer $confirm
 * @property integer $confirmsales
 * @property integer $type
 * @property integer $missed
 * @property string $dateaction
 * @property string $timeaction
 * @property string $file
 * @property string $code
 * @property integer $red
 * @property integer $yellow
 * @property integer $green
 * @property integer $blue
 * @property string $from_time
 * @property string $to_time
 * @property string $unit_ids
 * @property string $downpayment
 * @property string $months
 * @property string $amount
 * @property string $cash
 * @property string $cash_date
 * @property string $visit_date
 * @property string $attended
 */
class Visit extends CActiveRecord
{
    
    
    
    
     protected function beforeFind()
{
    // استدعاء الدالة الأصلية
    parent::beforeFind();

    // احصل على معرف المستخدم الحالي من الجلسة
    $currentUserId = Yii::app()->user->id;

    // تحقق من أن المعرف موجود
    if ($currentUserId) {
        // استعلام للحصول على جميع المعلومات من جدول المستخدمين بناءً على معرف المستخدم
        $userInfo = Yii::app()->db->createCommand()
            ->select('*') // اختر جميع الأعمدة أو الأعمدة التي تحتاجها فقط
            ->from('user') // اسم جدول المستخدمين
            ->where('id=:userId', array(':userId' => $currentUserId))
            ->queryRow();



        
        // Check if limitsformanager is not empty
        if (!empty($userInfo['limitsformanager'])) {
            
        $limitsArray = is_string($userInfo['limitsformanager']) ? explode(',', $userInfo['limitsformanager']) : $userInfo['limitsformanager'];
        // إضافة شرط الاستعلام بناءً على limitsformanager و currentUserId
        $this->getDbCriteria()->addCondition('user_id IN (' . implode(',', array_map('intval', $limitsArray)) . ') OR id = :userId');
        $this->getDbCriteria()->params[':userId'] = $currentUserId;    

        }

    return true; // تأكد من إرجاع true للسماح بمتابعة الاستعلام
}
}
    
    
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'visit';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id, lead_id, date', 'required'),
			array('user_id, lead_id, confirm, confirmsales, type, missed, red, yellow, green, blue, pending_visit', 'numerical', 'integerOnly'=>true),
			array('file, code, unit_ids, downpayment, months, amount, cash, attended, hour, novisit', 'length', 'max'=>255),
			array('cash_date', 'length', 'max'=>300),
			array('reason, dateaction, timeaction, from_time, to_time', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, lead_id, date, details, reason, confirm, confirmsales, type, missed, dateaction, timeaction, file, code, red, yellow, green, blue, from_time, to_time, unit_ids, downpayment, months, amount, cash, cash_date, attended, lead_date,  hour, novisit', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array( 'lead'    => array(self::BELONGS_TO, 'Leads',    'lead_id'),
	    'employee'    => array(self::BELONGS_TO, 'User',    'user_id'), ); 
	    
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'lead_id' => 'Lead',
			'date' => 'Date',
			'details' => 'Details',
			'reason' => 'Reason',
			'confirm' => 'Confirm',
			'confirmsales' => 'Confirmsales',
			'type' => 'Type',
			'missed' => 'Missed',
			'dateaction' => 'Dateaction',
			'timeaction' => 'Timeaction',
			'file' => 'File',
			'code' => 'Code',
			'red' => 'Red',
			'yellow' => 'Yellow',
			'green' => 'Green',
			'blue' => 'Blue',
			'from_time' => 'From Time',
			'to_time' => 'To Time',
			'unit_ids' => 'Unit Ids',
			'downpayment' => 'Downpayment',
			'months' => 'Months',
			'amount' => 'Amount',
			'cash' => 'Cash',
			'cash_date' => 'Cash Date',
			'attended' => 'Attended',
			'pending_visit' => 'Pending Visit',
			
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.



			$criteria = new CDbCriteria();
			$criteria->order = 'id DESC'; 
			
			
			
			
			
			
 
			$userid=Yii::app()->user->id;
  
$user= User::model()->findByPk($userid);

if($user->teamleader==1){
    
    	//	var_dump($userid);exit;

$allemployee = Teamleader::model()->findAll(array( 'condition' => 'leader_id=' . $userid,'order'=>'id DESC'  ));
if(!empty($allemployee)){
$arr=array();
foreach($allemployee as $leader){
$arr[]=$leader->sales_id;
} 
$criteria->addInCondition('user_id', $arr);
}
}

			
			
			if(!empty($_GET['Search']['user_id'] ))
			$criteria->addSearchCondition('user_id', $_GET['Search']['user_id']  ,false, "AND");

			if(!empty($_GET['Search']['startdate']) && !empty($_GET['Search']['enddate'] ))
			$criteria->addBetweenCondition("date",$_GET['Search']['startdate'],$_GET['Search']['enddate'],'AND');
			if(isset($_GET['Search']['visit'])){
			$criteria->addSearchCondition('confirmsales', $_GET['Search']['visit'],false, "AND");
			}
			
			$dataProvider = new CActiveDataProvider('Visit', array(
					'pagination' => array(
						'pageSize' =>50,
					),
					'criteria' => $criteria,
				));	
 
	    


		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	
	
	public function searchsales()
{
    $userid = Yii::app()->user->id;
    $today = date("Y-m-d");
    $visit = 1; 
    $start = date('Y-m-01'); // Use '01' for the first day of the month
    $end = date('Y-m-t');   // Use 't' to get the last day of the month
    $close = 1; // Assuming $close is the value you want to search for in 'confirmsales'

    $criteria = new CDbCriteria();

    if (!empty($_GET['sales'])) {
        $criteria->addSearchCondition('user_id', $_GET['sales'], false);
    } else {
        $criteria->addSearchCondition('user_id', $userid, false);
    }

    $criteria->addSearchCondition('confirmsales', $close, false);
    $criteria->addBetweenCondition("date", $start, $end, 'AND');

    return new CActiveDataProvider($this, array(
        'criteria' => $criteria,
    ));
}

	
	
	
	

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Visit the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
